/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.extension.parallelesi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Tag {
    private static final Pattern TAG_CLOSE_PATTERN = Pattern.compile("\\A</([\\S]*)[\\s]*>\\z");
    private static final Pattern TAG_START_PATTERN = Pattern.compile("\\A<([\\S]*)[\\s|>]");
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("([^\\s=]+)\\s*=\\s*('[^']*'|\"[^\"]*\")");
    private static final Pattern AUTO_CLOSE_TAG = Pattern.compile("/[\\s]*>\\z");
    private final String name;
    private final Map<String, String> attributes;
    private final boolean closing;
    private final boolean openClosed;

    public static Tag create(String tag) {
        Matcher closeMatcher = TAG_CLOSE_PATTERN.matcher(tag);
        if (closeMatcher.find()) {
            String name = closeMatcher.group(1);
            Map<String, String> attributes = Collections.emptyMap();
            return new Tag(name, true, false, attributes);
        }
        Matcher startMatcher = TAG_START_PATTERN.matcher(tag);
        if (startMatcher.find()) {
            String name = startMatcher.group(1);
            HashMap<String, String> attributes = new HashMap<String, String>();
            Matcher attributesMatcher = ATTRIBUTE_PATTERN.matcher(tag);
            while (attributesMatcher.find()) {
                attributes.put(attributesMatcher.group(1), tag.substring(attributesMatcher.start(2) + 1, attributesMatcher.end(2) - 1));
            }
            boolean openClosed = AUTO_CLOSE_TAG.matcher(tag).find();
            return new Tag(name, false, openClosed, attributes);
        }
        throw new IllegalArgumentException("invalid tag string: '" + tag + "'");
    }

    Tag(String name, boolean closing, boolean openClosed, Map<String, String> attributes) {
        this.name = name;
        this.closing = closing;
        this.openClosed = openClosed;
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean isClosing() {
        return this.closing;
    }

    public boolean isOpenClosed() {
        return this.openClosed;
    }
}

