/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.io.IOException;
import java.sql.Date;
import java.util.Properties;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.esigate.ConfigurationException;
import org.esigate.Parameters;
import org.esigate.events.EventManager;
import org.esigate.events.impl.FetchEvent;
import org.esigate.http.DateUtils;

public class CacheAdapter {
    private int staleIfError;
    private int staleWhileRevalidate;
    private int ttl;
    private boolean xCacheHeader;
    private boolean viaHeader;

    public void init(Properties properties) {
        this.staleIfError = Parameters.STALE_IF_ERROR.getValueInt(properties);
        this.staleWhileRevalidate = Parameters.STALE_WHILE_REVALIDATE.getValueInt(properties);
        int maxAsynchronousWorkers = Parameters.MAX_ASYNCHRONOUS_WORKERS.getValueInt(properties);
        if (this.staleWhileRevalidate > 0 && maxAsynchronousWorkers == 0) {
            throw new ConfigurationException("You must set a positive value for maxAsynchronousWorkers in order to enable background revalidation (staleWhileRevalidate)");
        }
        this.ttl = Parameters.TTL.getValueInt(properties);
        this.xCacheHeader = Parameters.X_CACHE_HEADER.getValueBoolean(properties);
        this.viaHeader = Parameters.VIA_HEADER.getValueBoolean(properties);
    }

    public HttpClient wrapCachingHttpClient(HttpClient wrapped) {
        return new HttpClientWrapper(wrapped){

            boolean transformRequest(HttpRequest httpRequest, HttpContext context) {
                return true;
            }

            void transformResponse(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext context) {
                if (httpRequest.getRequestLine().getMethod().equalsIgnoreCase("GET") && (CacheAdapter.this.staleWhileRevalidate > 0 || CacheAdapter.this.staleIfError > 0)) {
                    httpResponse.removeHeader(httpResponse.getLastHeader("Cache-control"));
                }
                if (CacheAdapter.this.xCacheHeader && context != null) {
                    CacheResponseStatus cacheResponseStatus = (CacheResponseStatus)context.getAttribute("http.cache.response.status");
                    HttpHost host = (HttpHost)context.getAttribute("http.target_host");
                    String xCacheString = cacheResponseStatus.equals((Object)CacheResponseStatus.CACHE_HIT) ? "HIT" : (cacheResponseStatus.equals((Object)CacheResponseStatus.VALIDATED) ? "VALIDATED" : "MISS");
                    xCacheString = xCacheString + " from " + host.toHostString();
                    xCacheString = xCacheString + " (" + httpRequest.getRequestLine().getMethod() + " " + httpRequest.getRequestLine().getUri() + ")";
                    httpResponse.addHeader("X-Cache", xCacheString);
                }
                if (!CacheAdapter.this.viaHeader && httpResponse.containsHeader("Via")) {
                    httpResponse.removeHeaders("Via");
                }
            }
        };
    }

    public HttpClient wrapBackendHttpClient(final EventManager eventManager, HttpClient wrapped) {
        return new HttpClientWrapper(wrapped){

            boolean transformRequest(HttpRequest httpRequest, HttpContext context) {
                FetchEvent e = new FetchEvent();
                e.httpRequest = httpRequest;
                e.httpResponse = null;
                e.httpContext = context;
                eventManager.fire(EventManager.EVENT_FETCH_PRE, e);
                return !e.exit;
            }

            void transformResponse(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext context) {
                FetchEvent e = new FetchEvent();
                e.httpRequest = httpRequest;
                e.httpResponse = httpResponse;
                e.httpContext = context;
                eventManager.fire(EventManager.EVENT_FETCH_POST, e);
                String method = httpRequest.getRequestLine().getMethod();
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (CacheAdapter.this.ttl > 0 && method.equalsIgnoreCase("GET") && this.isCacheableStatus(statusCode)) {
                    httpResponse.removeHeaders("Date");
                    httpResponse.removeHeaders("Cache-control");
                    httpResponse.removeHeaders("Expires");
                    httpResponse.setHeader("Date", DateUtils.formatDate(new Date(System.currentTimeMillis())));
                    httpResponse.setHeader("Cache-control", "public, max-age=" + CacheAdapter.this.ttl);
                    httpResponse.setHeader("Expires", DateUtils.formatDate(new Date(System.currentTimeMillis() + (long)CacheAdapter.this.ttl * 1000L)));
                }
                if (httpRequest.getRequestLine().getMethod().equalsIgnoreCase("GET")) {
                    String cacheControlHeader = "";
                    if (CacheAdapter.this.staleWhileRevalidate > 0) {
                        cacheControlHeader = cacheControlHeader + "stale-while-revalidate=" + CacheAdapter.this.staleWhileRevalidate;
                    }
                    if (CacheAdapter.this.staleIfError > 0) {
                        if (cacheControlHeader.length() > 0) {
                            cacheControlHeader = cacheControlHeader + ",";
                        }
                        cacheControlHeader = cacheControlHeader + "stale-if-error=" + CacheAdapter.this.staleIfError;
                    }
                    if (cacheControlHeader.length() > 0) {
                        httpResponse.addHeader("Cache-control", cacheControlHeader);
                    }
                }
            }

            private boolean isCacheableStatus(int statusCode) {
                return statusCode == 200 || statusCode == 301 || statusCode == 302 || statusCode == 404 || statusCode == 500 || statusCode == 503 || statusCode == 304;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HttpClientWrapper
    implements HttpClient {
        private final HttpClient wrapped;

        HttpClientWrapper(HttpClient wrapped) {
            this.wrapped = wrapped;
        }

        public HttpParams getParams() {
            return this.wrapped.getParams();
        }

        public ClientConnectionManager getConnectionManager() {
            return this.wrapped.getConnectionManager();
        }

        public <T> T execute(HttpHost target, final HttpRequest request, final ResponseHandler<? extends T> responseHandler, final HttpContext context) throws IOException, ClientProtocolException {
            if (this.transformRequest(request, context)) {
                Object response = this.wrapped.execute(target, request, new ResponseHandler<T>(){

                    public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                        HttpClientWrapper.this.transformResponse(request, response, context);
                        return responseHandler.handleResponse(response);
                    }
                }, context);
                return (T)response;
            }
            return null;
        }

        public <T> T execute(HttpHost target, final HttpRequest request, final ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
            if (this.transformRequest(request, null)) {
                Object response = this.wrapped.execute(target, request, new ResponseHandler<T>(){

                    public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                        HttpClientWrapper.this.transformResponse(request, response, null);
                        return responseHandler.handleResponse(response);
                    }
                });
                return (T)response;
            }
            return null;
        }

        public <T> T execute(final HttpUriRequest request, final ResponseHandler<? extends T> responseHandler, final HttpContext context) throws IOException, ClientProtocolException {
            if (this.transformRequest((HttpRequest)request, context)) {
                Object response = this.wrapped.execute(request, new ResponseHandler<T>(){

                    public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                        HttpClientWrapper.this.transformResponse((HttpRequest)request, response, context);
                        return responseHandler.handleResponse(response);
                    }
                }, context);
                return (T)response;
            }
            return null;
        }

        public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
            if (this.transformRequest(request, context)) {
                HttpResponse response = this.wrapped.execute(target, request, context);
                this.transformResponse(request, response, context);
                return response;
            }
            return null;
        }

        public <T> T execute(final HttpUriRequest request, final ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
            if (this.transformRequest((HttpRequest)request, null)) {
                Object response = this.wrapped.execute(request, new ResponseHandler<T>(){

                    public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                        HttpClientWrapper.this.transformResponse((HttpRequest)request, response, null);
                        return responseHandler.handleResponse(response);
                    }
                });
                return (T)response;
            }
            return null;
        }

        public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
            if (this.transformRequest(request, null)) {
                HttpResponse response = this.wrapped.execute(target, request);
                this.transformResponse(request, response, null);
                return response;
            }
            return null;
        }

        public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
            if (this.transformRequest((HttpRequest)request, context)) {
                HttpResponse response = this.wrapped.execute(request, context);
                this.transformResponse((HttpRequest)request, response, context);
                return response;
            }
            return null;
        }

        public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
            if (this.transformRequest((HttpRequest)request, null)) {
                HttpResponse response = this.wrapped.execute(request);
                this.transformResponse((HttpRequest)request, response, null);
                return response;
            }
            return null;
        }

        abstract boolean transformRequest(HttpRequest var1, HttpContext var2);

        abstract void transformResponse(HttpRequest var1, HttpResponse var2, HttpContext var3);
    }
}

