/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.url;

import org.apache.http.HttpRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.esigate.api.BaseUrlRetrieveStrategy;
import org.esigate.api.ContainerRequestMediator;
import org.esigate.util.HttpRequestHelper;

public class StickySessionBaseUrlRetrieveStrategy
implements BaseUrlRetrieveStrategy {
    public static final String ESI_SESSION_COOKIE_NAME = "_esigate_session_cookie";
    private final String[] urls;

    public StickySessionBaseUrlRetrieveStrategy(String[] urls) {
        this.urls = urls;
    }

    public String getBaseURL(HttpRequest originalRequest) {
        ContainerRequestMediator mediator = HttpRequestHelper.getMediator(originalRequest);
        Cookie sessionCookie = this.getEsiSessionCookie(mediator.getCookies());
        int index = 0;
        boolean toGenerate = true;
        if (null != sessionCookie) {
            toGenerate = false;
            String indexStr = sessionCookie.getValue();
            if (null != indexStr) {
                try {
                    Integer indexInt = Integer.parseInt(indexStr);
                    index = indexInt;
                }
                catch (Exception e) {
                    index = -1;
                }
                if (index < 0 || index >= this.urls.length) {
                    toGenerate = true;
                }
            } else {
                toGenerate = true;
            }
        }
        if (toGenerate) {
            index = this.generateIndex();
            BasicClientCookie cookie = new BasicClientCookie(ESI_SESSION_COOKIE_NAME, Integer.toString(index));
            mediator.addCookie((Cookie)cookie);
        }
        return this.urls[index];
    }

    private int generateIndex() {
        return (int)(Math.random() * (double)this.urls.length);
    }

    private Cookie getEsiSessionCookie(Cookie[] cookies) {
        Cookie ret = null;
        if (null != cookies && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!ESI_SESSION_COOKIE_NAME.equals(cookie.getName())) continue;
                ret = cookie;
                break;
            }
        }
        return ret;
    }
}

