/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.esi;

import java.io.IOException;
import org.esigate.HttpErrorPage;
import org.esigate.esi.BaseElement;
import org.esigate.esi.BaseElementType;
import org.esigate.esi.InlineCache;
import org.esigate.esi.Tag;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContext;
import org.esigate.util.UriUtils;

class InlineElement
extends BaseElement {
    public static final ElementType TYPE = new BaseElementType("<esi:inline", "</esi:inline"){

        public InlineElement newInstance() {
            return new InlineElement();
        }
    };
    private String uri;
    private boolean fetchable;
    private StringBuilder buf = new StringBuilder();

    InlineElement() {
    }

    protected void parseTag(Tag tag, ParserContext ctx) {
        this.uri = tag.getAttribute("name");
        this.fetchable = "yes".equalsIgnoreCase(tag.getAttribute("fetchable"));
    }

    public void characters(CharSequence csq, int start, int end) {
        this.buf.append(csq, start, end);
    }

    public void onTagEnd(String tag, ParserContext ctx) throws IOException, HttpErrorPage {
        String originalUrl = UriUtils.createUri(ctx.getHttpRequest().getRequestLine().getUri()).getPath();
        InlineCache.storeFragment(this.uri, null, this.fetchable, originalUrl, this.buf.toString());
    }
}

