/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;

public class IOExceptionHandler {
    public static final HttpResponse toHttpResponse(IOException exception) {
        if (exception instanceof HttpHostConnectException) {
            int statusCode = 502;
            String statusText = "Connection refused";
            return new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusText));
        }
        if (exception instanceof ConnectionPoolTimeoutException) {
            int statusCode = 504;
            String statusText = "Connection pool timeout";
            return new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusText));
        }
        if (exception instanceof ConnectTimeoutException) {
            int statusCode = 504;
            String statusText = "Connect timeout";
            return new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusText));
        }
        if (exception instanceof SocketTimeoutException) {
            int statusCode = 504;
            String statusText = "Socket timeout";
            return new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusText));
        }
        if (exception instanceof SocketException) {
            int statusCode = 502;
            String statusText = "Socket Exception";
            return new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusText));
        }
        int statusCode = 500;
        String statusText = "Error retrieving URL";
        return new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusText));
    }
}

