/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cookie;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.http.HttpRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BasicClientCookie2;
import org.esigate.ConfigurationException;
import org.esigate.Driver;
import org.esigate.Parameters;
import org.esigate.UserContext;
import org.esigate.cookie.CookieManager;
import org.esigate.util.HttpRequestHelper;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCookieManager
implements CookieManager {
    private static final Logger LOG = LoggerFactory.getLogger(CookieManager.class);
    private static final String COOKIES_LIST_SESSION_KEY = CookieManager.class.getName() + "#cookies";
    protected Collection<String> discardCookies;
    protected Collection<String> forwardCookies;

    @Override
    public void init(Driver d, Properties properties) {
        this.forwardCookies = Parameters.FORWARD_COOKIES.getValueList(properties);
        this.discardCookies = Parameters.DISCARD_COOKIES.getValueList(properties);
        if (this.forwardCookies.contains("*") && this.forwardCookies.size() > 1) {
            throw new ConfigurationException("forwardCookies must be a list of cookie names OR *");
        }
        if (this.discardCookies.contains("*") && this.discardCookies.size() > 1) {
            throw new ConfigurationException("discardCookies must be a list of cookie names OR *");
        }
        if (this.forwardCookies.contains("*") && this.discardCookies.contains("*")) {
            throw new ConfigurationException("cannot use * for forwardCookies AND discardCookies at the same time");
        }
    }

    @Override
    public void addCookie(Cookie cookie, HttpRequest originalRequest) {
        String name = cookie.getName();
        if (this.discardCookies.contains(name) || this.discardCookies.contains("*") && !this.forwardCookies.contains(name)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Cookie " + this.toString(cookie) + " -> discarding");
            }
        } else if (this.forwardCookies.contains(name) || this.forwardCookies.contains("*")) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Cookie " + this.toString(cookie) + " -> forwarding");
            }
            HttpRequestHelper.getMediator(originalRequest).addCookie(DefaultCookieManager.rewriteForBrowser(cookie, originalRequest));
        } else {
            UserContext userContext;
            ArrayList<Cookie> cookies;
            if (LOG.isInfoEnabled()) {
                LOG.info("Cookie " + this.toString(cookie) + " -> storing to context");
            }
            if ((cookies = (ArrayList<Cookie>)(userContext = HttpRequestHelper.getUserContext(originalRequest)).getAttribute(COOKIES_LIST_SESSION_KEY)) == null) {
                cookies = new ArrayList<Cookie>();
            }
            cookies.add(cookie);
            userContext.setAttribute(COOKIES_LIST_SESSION_KEY, cookies);
        }
    }

    @Override
    public List<Cookie> getCookies(HttpRequest originalRequest) {
        Cookie[] requestCookies;
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        UserContext userContext = HttpRequestHelper.getUserContext(originalRequest);
        List sessionCookies = (List)userContext.getAttribute(COOKIES_LIST_SESSION_KEY);
        if (sessionCookies != null) {
            cookies.addAll(sessionCookies);
        }
        if ((requestCookies = HttpRequestHelper.getMediator(originalRequest).getCookies()) != null) {
            for (Cookie cookie : requestCookies) {
                String name = cookie.getName();
                if (!this.forwardCookies.contains(name) && (!this.forwardCookies.contains("*") || this.discardCookies.contains(name))) continue;
                cookies.add(DefaultCookieManager.rewriteForServer(cookie, originalRequest));
            }
        }
        return cookies;
    }

    private static Cookie rewriteForServer(Cookie cookie, HttpRequest originalRequest) {
        String name = cookie.getName();
        if ("_JSESSIONID".equalsIgnoreCase(name)) {
            name = name.substring(1);
        }
        BasicClientCookie2 httpClientCookie = new BasicClientCookie2(name, cookie.getValue());
        httpClientCookie.setSecure(false);
        String domain = HttpRequestHelper.getDriver(originalRequest).getConfiguration().isPreserveHost() ? UriUtils.extractHostName(originalRequest.getRequestLine().getUri()) : HttpRequestHelper.getBaseUrl(originalRequest).getHost();
        httpClientCookie.setDomain(domain);
        httpClientCookie.setPath("/");
        httpClientCookie.setComment(cookie.getComment());
        httpClientCookie.setVersion(cookie.getVersion());
        return httpClientCookie;
    }

    protected static String rewriteDomain(String originalDomain, String providerHostName, String requestHostName) {
        String domain = null;
        if (!providerHostName.equals(originalDomain)) {
            String[] requestHostNameParts;
            String[] originalDomainParts;
            int targetLength;
            if (originalDomain.startsWith(".")) {
                originalDomain = originalDomain.substring(1);
            }
            if ((targetLength = Math.min((originalDomainParts = originalDomain.split("\\.")).length, (requestHostNameParts = requestHostName.split("\\.")).length)) == requestHostNameParts.length) {
                return null;
            }
            domain = "";
            for (int i = requestHostNameParts.length; i > requestHostNameParts.length - targetLength; --i) {
                domain = "." + requestHostNameParts[i - 1] + domain;
            }
        }
        return domain;
    }

    private static Cookie rewriteForBrowser(Cookie cookie, HttpRequest originalRequest) {
        String name = cookie.getName();
        if ("JSESSIONID".equalsIgnoreCase(name)) {
            name = "_" + name;
        }
        String domain = DefaultCookieManager.rewriteDomain(cookie.getDomain(), HttpRequestHelper.getBaseUrl(originalRequest).getHost(), UriUtils.extractHostName(originalRequest.getRequestLine().getUri()));
        String originalPath = cookie.getPath();
        String requestPath = UriUtils.createUri(originalRequest.getRequestLine().getUri()).getPath();
        String path = originalPath;
        if (requestPath == null || !requestPath.startsWith(originalPath)) {
            path = "/";
        }
        boolean secure = cookie.isSecure() && originalRequest.getRequestLine().getUri().startsWith("https");
        BasicClientCookie cookieToForward = new BasicClientCookie(name, cookie.getValue());
        if (domain != null) {
            cookieToForward.setDomain(domain);
        }
        cookieToForward.setPath(path);
        cookieToForward.setSecure(secure);
        cookieToForward.setComment(cookie.getComment());
        cookieToForward.setVersion(cookie.getVersion());
        cookieToForward.setExpiryDate(cookie.getExpiryDate());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forwarding cookie {} -> {}", (Object)cookie.toString(), (Object)cookieToForward.toString());
        }
        return cookieToForward;
    }

    private String toString(Cookie cookie) {
        StringBuilder result = new StringBuilder();
        result.append(cookie.getName());
        result.append("=");
        result.append(cookie.getValue());
        if (cookie.getDomain() != null) {
            result.append(";domain=");
            result.append(cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            result.append(";path=");
            result.append(cookie.getPath());
        }
        if (cookie.getExpiryDate() != null) {
            result.append(";expires=");
            result.append(cookie.getExpiryDate());
        }
        if (cookie.getCommentURL() != null) {
            result.append(";comment=");
            result.append(cookie.getComment());
        }
        if (cookie.getCommentURL() != null) {
            result.append(";comment=");
            result.append(cookie.getCommentURL());
        }
        return result.toString();
    }

    @Override
    public boolean clearExpired(Date date, HttpRequest originalRequest) {
        if (date == null) {
            return false;
        }
        UserContext userContext = HttpRequestHelper.getUserContext(originalRequest);
        List cookies = (List)userContext.getAttribute(COOKIES_LIST_SESSION_KEY);
        if (cookies != null) {
            boolean removed = false;
            Iterator it = cookies.iterator();
            while (it.hasNext()) {
                if (!((Cookie)it.next()).isExpired(date)) continue;
                it.remove();
                removed = true;
            }
            return removed;
        }
        return false;
    }

    @Override
    public void clear(HttpRequest originalRequest) {
        UserContext userContext = HttpRequestHelper.getUserContext(originalRequest);
        List cookies = (List)userContext.getAttribute(COOKIES_LIST_SESSION_KEY);
        if (cookies != null) {
            cookies.clear();
            userContext.setAttribute(COOKIES_LIST_SESSION_KEY, (Serializable)((Object)cookies));
        }
    }
}

