/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.authentication;

import java.util.Properties;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.esigate.Driver;
import org.esigate.events.Event;
import org.esigate.events.EventDefinition;
import org.esigate.events.EventManager;
import org.esigate.events.IEventListener;
import org.esigate.events.impl.FragmentEvent;
import org.esigate.events.impl.ProxyEvent;
import org.esigate.extension.Extension;
import org.esigate.http.GenericHttpRequest;
import org.esigate.http.HttpResponseUtils;

public abstract class GenericAuthentificationHandler
implements IEventListener,
Extension {
    protected Driver driver;

    public abstract boolean beforeProxy(HttpRequest var1);

    public abstract void preRequest(GenericHttpRequest var1, HttpRequest var2);

    public abstract boolean needsNewRequest(HttpResponse var1, HttpRequest var2);

    public void init(Driver d, Properties properties) {
        this.driver = d;
        this.driver.getEventManager().register(EventManager.EVENT_PROXY_PRE, this);
        this.driver.getEventManager().register(EventManager.EVENT_FRAGMENT_PRE, this);
        this.driver.getEventManager().register(EventManager.EVENT_FRAGMENT_POST, this);
        this.init(properties);
    }

    public abstract void init(Properties var1);

    public boolean event(EventDefinition id, Event event) {
        if (EventManager.EVENT_FRAGMENT_PRE.equals(id)) {
            FragmentEvent e = (FragmentEvent)event;
            this.preRequest(e.httpRequest, (HttpRequest)e.originalRequest);
        } else if (EventManager.EVENT_FRAGMENT_POST.equals(id)) {
            FragmentEvent e = (FragmentEvent)event;
            while (this.needsNewRequest(e.httpResponse, (HttpRequest)e.originalRequest)) {
                HttpResponseUtils.release(e.httpResponse);
                e.httpResponse = this.driver.executeSingleRequest(e.httpRequest);
            }
        } else if (EventManager.EVENT_PROXY_PRE.equals(id)) {
            ProxyEvent e = (ProxyEvent)event;
            e.exit = !this.beforeProxy(e.originalRequest);
        }
        return true;
    }
}

