/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.esigate.ConfigurationException;
import org.esigate.Driver;
import org.esigate.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverFactory {
    private static final Map<String, Driver> INSTANCES = new HashMap<String, Driver>();
    private static final String DEFAULT_INSTANCE_NAME = "default";
    private static final Logger LOG = LoggerFactory.getLogger(DriverFactory.class);

    private DriverFactory() {
    }

    public static final void configure() {
        InputStream inputStream = null;
        InputStream extInputStream = null;
        try {
            String envPath = System.getProperty("esigate.config");
            if (envPath != null) {
                try {
                    LOG.info("Scanning configuration {}", (Object)envPath);
                    inputStream = new FileInputStream(new File(envPath));
                }
                catch (FileNotFoundException e) {
                    LOG.error("Can't read file {} (from -Desigate.config)", (Object)envPath, (Object)e);
                }
            }
            if (inputStream == null) {
                LOG.info("Scanning configuration {}", (Object)"/esigate.properties");
                inputStream = DriverFactory.class.getResourceAsStream("/esigate.properties");
            }
            if (inputStream == null) {
                LOG.info("Scanning configuration /{}/{}", (Object)DriverFactory.class.getPackage().getName().replace(".", "/"), (Object)"driver.properties");
                inputStream = DriverFactory.class.getResourceAsStream("driver.properties");
            }
            if (inputStream == null) {
                LOG.info("Scanning configuration {}", (Object)"/net/webassembletool/driver.properties");
                inputStream = DriverFactory.class.getResourceAsStream("/net/webassembletool/driver.properties");
            }
            if (inputStream == null) {
                throw new ConfigurationException("esigate.properties configuration file was not found in the classpath");
            }
            LOG.info("Scanning configuration {}", (Object)"/esigate-ext.properties");
            extInputStream = DriverFactory.class.getClassLoader().getResourceAsStream("/esigate-ext.properties");
            if (extInputStream == null) {
                LOG.info("Scanning configuration {}", (Object)"/driver-ext.properties");
                extInputStream = DriverFactory.class.getResourceAsStream("/driver-ext.properties");
            }
            if (extInputStream == null) {
                LOG.info("Scanning configuration /{}/{}", (Object)DriverFactory.class.getPackage().getName().replace(".", "/"), (Object)"driver-ext.properties");
                extInputStream = DriverFactory.class.getResourceAsStream("driver-ext.properties");
            }
            Properties merged = new Properties();
            if (inputStream != null) {
                Properties props = new Properties();
                props.load(inputStream);
                merged.putAll((Map<?, ?>)props);
            }
            if (extInputStream != null) {
                Properties extProps = new Properties();
                extProps.load(extInputStream);
                merged.putAll((Map<?, ?>)extProps);
            }
            DriverFactory.configure(merged);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error loading configuration", e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (extInputStream != null) {
                    extInputStream.close();
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("failed to close stream", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void configure(Properties props) {
        Properties defaultProperties = new Properties();
        HashMap<String, Properties> driversProps = new HashMap<String, Properties>();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            String value = props.getProperty(propertyName);
            int idx = propertyName.lastIndexOf(46);
            if (idx < 0) {
                defaultProperties.put(propertyName, value);
                continue;
            }
            String prefix = propertyName.substring(0, idx);
            String name = propertyName.substring(idx + 1);
            Properties driverProperties = (Properties)driversProps.get(prefix);
            if (driverProperties == null) {
                driverProperties = new Properties();
                driversProps.put(prefix, driverProperties);
            }
            driverProperties.put(name, value);
        }
        Map<String, Driver> map = INSTANCES;
        synchronized (map) {
            INSTANCES.clear();
            for (Map.Entry entry : driversProps.entrySet()) {
                String name = (String)entry.getKey();
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)defaultProperties);
                properties.putAll((Map<?, ?>)((Map)entry.getValue()));
                DriverFactory.configure(name, properties);
            }
            if (INSTANCES.get(DEFAULT_INSTANCE_NAME) == null && Parameters.REMOTE_URL_BASE.getValueString(defaultProperties) != null) {
                DriverFactory.configure(DEFAULT_INSTANCE_NAME, defaultProperties);
            }
        }
    }

    public static void configure(String name, Properties props) {
        INSTANCES.put(name, new Driver(name, props));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Driver getInstance(String instanceName) {
        Map<String, Driver> map = INSTANCES;
        synchronized (map) {
            if (instanceName == null) {
                instanceName = DEFAULT_INSTANCE_NAME;
            }
            if (INSTANCES.isEmpty()) {
                throw new ConfigurationException("Driver has not been configured and driver.properties file was not found");
            }
            Driver instance = INSTANCES.get(instanceName);
            if (instance == null) {
                throw new ConfigurationException("No configuration properties found for factory : " + instanceName);
            }
            return instance;
        }
    }

    public static final Driver getInstance() {
        return DriverFactory.getInstance(DEFAULT_INSTANCE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void put(String instanceName, Driver instance) {
        Map<String, Driver> map = INSTANCES;
        synchronized (map) {
            INSTANCES.put(instanceName, instance);
        }
    }

    static {
        DriverFactory.configure();
    }
}

