/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.xml;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.dom.HtmlDocumentBuilder;
import org.apache.http.HttpEntityEnclosingRequest;
import org.esigate.Renderer;
import org.esigate.xml.HtmlNamespaceContext;
import org.esigate.xml.ProcessingFailedException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XpathRenderer
implements Renderer {
    private static final HtmlNamespaceContext HTML_NAMESPACE_CONTEXT = new HtmlNamespaceContext();
    private static final XPathFactory X_PATH_FACTORY = XPathFactory.newInstance();
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private final XPathExpression expr;
    private final String outputMethod;

    public XpathRenderer(String xpath) {
        this(xpath, "xml");
    }

    public XpathRenderer(String xpath, String outputMethod) {
        try {
            XPath xpathObj = X_PATH_FACTORY.newXPath();
            xpathObj.setNamespaceContext(HTML_NAMESPACE_CONTEXT);
            this.expr = xpathObj.compile(xpath);
            this.outputMethod = outputMethod;
        }
        catch (XPathExpressionException e) {
            throw new ProcessingFailedException("failed to compile XPath expression", e);
        }
    }

    public void render(HttpEntityEnclosingRequest httpRequest, String src, Writer out) throws IOException {
        try {
            HtmlDocumentBuilder htmlDocumentBuilder = new HtmlDocumentBuilder(XmlViolationPolicy.ALLOW);
            htmlDocumentBuilder.setDoctypeExpectation(DoctypeExpectation.NO_DOCTYPE_ERRORS);
            Document document = htmlDocumentBuilder.parse(new InputSource(new StringReader(src)));
            Node xpathed = (Node)this.expr.evaluate(document, XPathConstants.NODE);
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", this.outputMethod);
            DOMSource source = new DOMSource(xpathed);
            transformer.transform(source, new StreamResult(out));
        }
        catch (XPathExpressionException e) {
            throw new ProcessingFailedException("Failed to evaluate XPath expression", e);
        }
        catch (TransformerException e) {
            throw new ProcessingFailedException("Unable to parse source", e);
        }
        catch (SAXException e) {
            throw new ProcessingFailedException("Unable to parse source", e);
        }
    }
}

