/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.servlet.HttpServletMediator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ProxyServlet.class);
    private String provider;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String relUrl = request.getRequestURI();
        relUrl = relUrl.substring(request.getContextPath().length());
        if (request.getServletPath() != null) {
            relUrl = relUrl.substring(request.getServletPath().length());
        }
        LOG.debug("Proxying " + relUrl);
        HttpServletMediator mediator = new HttpServletMediator(request, response, this.getServletContext());
        try {
            DriverFactory.getInstance(this.provider).proxy(relUrl, mediator.getHttpRequest(), new Renderer[0]);
        }
        catch (HttpErrorPage e) {
            mediator.sendResponse(e.getHttpResponse());
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.provider = config.getInitParameter("provider");
    }
}

