/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.BasicRequestLine;
import org.esigate.api.ContainerRequestMediator;
import org.esigate.util.HttpRequestHelper;
import org.esigate.util.UriUtils;

public class HttpServletMediator
implements ContainerRequestMediator {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletContext servletContext;
    private final HttpEntityEnclosingRequest httpRequest;

    public HttpServletMediator(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException {
        this.request = request;
        this.response = response;
        this.servletContext = servletContext;
        String uri = UriUtils.createURI(request.getScheme(), request.getServerName(), request.getServerPort(), request.getRequestURI(), request.getQueryString(), null).toString();
        ProtocolVersion protocolVersion = BasicLineParser.parseProtocolVersion((String)request.getProtocol(), null);
        BasicHttpEntityEnclosingRequest result = new BasicHttpEntityEnclosingRequest((RequestLine)new BasicRequestLine(request.getMethod(), uri, protocolVersion));
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                result.addHeader(name, value);
            }
        }
        ServletInputStream inputStream = request.getInputStream();
        if (inputStream != null) {
            String contentEncodingHeader;
            String contentLengthHeader = request.getHeader("Content-Length");
            long contentLength = contentLengthHeader != null ? Long.parseLong(contentLengthHeader) : -1L;
            InputStreamEntity entity = new InputStreamEntity((InputStream)inputStream, contentLength);
            String contentTypeHeader = request.getContentType();
            if (contentTypeHeader != null) {
                entity.setContentType(contentTypeHeader);
            }
            if ((contentEncodingHeader = request.getCharacterEncoding()) != null) {
                entity.setContentEncoding(contentEncodingHeader);
            }
            result.setEntity((HttpEntity)entity);
        }
        HttpRequestHelper.setMediator((HttpRequest)result, this);
        this.httpRequest = result;
    }

    public Cookie[] getCookies() {
        javax.servlet.http.Cookie[] src = this.request.getCookies();
        Cookie[] result = null;
        if (src != null) {
            result = new Cookie[src.length];
            for (int i = 0; i < src.length; ++i) {
                javax.servlet.http.Cookie c = src[i];
                BasicClientCookie dest = new BasicClientCookie(c.getName(), c.getValue());
                dest.setSecure(c.getSecure());
                dest.setDomain(c.getDomain());
                dest.setPath(c.getPath());
                dest.setComment(c.getComment());
                dest.setVersion(c.getVersion());
                result[i] = dest;
            }
        }
        return result;
    }

    public void addCookie(Cookie src) {
        this.response.addCookie(HttpServletMediator.rewriteCookie(src));
    }

    static javax.servlet.http.Cookie rewriteCookie(Cookie src) {
        javax.servlet.http.Cookie servletCookie = new javax.servlet.http.Cookie(src.getName(), src.getValue());
        if (src.getDomain() != null) {
            servletCookie.setDomain(src.getDomain());
        }
        servletCookie.setPath(src.getPath());
        servletCookie.setSecure(src.isSecure());
        servletCookie.setComment(src.getComment());
        servletCookie.setVersion(src.getVersion());
        if (src.getExpiryDate() != null) {
            int maxAge = (int)((src.getExpiryDate().getTime() - System.currentTimeMillis()) / 1000L);
            if (maxAge < 0) {
                maxAge = 0;
            }
            servletCookie.setMaxAge(maxAge);
        }
        return servletCookie;
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public void sendResponse(HttpResponse httpResponse) throws IOException {
        this.response.setStatus(httpResponse.getStatusLine().getStatusCode());
        for (Header header : httpResponse.getAllHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            this.response.addHeader(name, value);
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            Header contentEncoding;
            Header contentType;
            long contentLength = httpEntity.getContentLength();
            if (contentLength > -1L && contentLength < Integer.MAX_VALUE) {
                this.response.setContentLength((int)contentLength);
            }
            if ((contentType = httpEntity.getContentType()) != null) {
                this.response.setContentType(contentType.getValue());
            }
            if ((contentEncoding = httpEntity.getContentEncoding()) != null) {
                this.response.setHeader(contentEncoding.getName(), contentEncoding.getValue());
            }
            httpEntity.writeTo((OutputStream)this.response.getOutputStream());
        }
    }

    public void setSessionAttribute(String key, Serializable value) {
        HttpSession session = this.request.getSession();
        session.setAttribute(key, (Object)value);
    }

    public Serializable getSessionAttribute(String key) {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return null;
        }
        return (Serializable)session.getAttribute(key);
    }

    public InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    @Deprecated
    public String getSessionId() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            return session.getId();
        }
        return null;
    }

    public HttpEntityEnclosingRequest getHttpRequest() {
        return this.httpRequest;
    }
}

