/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.esigate.HttpErrorPage;
import org.esigate.Parameters;
import org.esigate.http.HttpResponseUtils;
import org.esigate.util.FilterList;
import org.esigate.util.HttpRequestHelper;
import org.esigate.util.PropertiesUtil;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderManager {
    private static final Logger LOG = LoggerFactory.getLogger(HeaderManager.class);
    private final FilterList requestHeadersFilterList = new FilterList();
    private final FilterList responseHeadersFilterList = new FilterList();

    public HeaderManager(Properties properties) {
        this.requestHeadersFilterList.add(Collections.singletonList("*"));
        this.responseHeadersFilterList.add(Collections.singletonList("*"));
        PropertiesUtil.populate(this.requestHeadersFilterList, properties, Parameters.FORWARD_REQUEST_HEADERS.name, Parameters.DISCARD_REQUEST_HEADERS.name, "", Parameters.DISCARD_REQUEST_HEADERS.defaultValue);
        PropertiesUtil.populate(this.responseHeadersFilterList, properties, Parameters.FORWARD_RESPONSE_HEADERS.name, Parameters.DISCARD_RESPONSE_HEADERS.name, "", Parameters.DISCARD_RESPONSE_HEADERS.defaultValue);
    }

    protected boolean isForwardedRequestHeader(String headerName) {
        return this.requestHeadersFilterList.contains(headerName);
    }

    protected boolean isForwardedResponseHeader(String headerName) {
        return this.responseHeadersFilterList.contains(headerName);
    }

    public void copyHeaders(HttpRequest originalRequest, HttpRequest httpRequest) throws HttpErrorPage {
        String originalUri = originalRequest.getRequestLine().getUri();
        String uri = httpRequest.getRequestLine().getUri();
        for (Header header : originalRequest.getAllHeaders()) {
            if ("User-Agent".equalsIgnoreCase(header.getName()) && this.isForwardedRequestHeader("User-Agent")) {
                httpRequest.getParams().setParameter("http.useragent", (Object)header.getValue());
                continue;
            }
            if ("Referer".equalsIgnoreCase(header.getName()) && this.isForwardedRequestHeader("Referer")) {
                String value = header.getValue();
                try {
                    value = UriUtils.translateUrl(value, originalUri, uri);
                }
                catch (MalformedURLException e) {
                    throw new HttpErrorPage(400, "Bad request", e);
                }
                httpRequest.addHeader(header.getName(), value);
                continue;
            }
            if (!this.isForwardedRequestHeader(header.getName())) continue;
            httpRequest.addHeader(header);
        }
        String remoteAddr = HttpRequestHelper.getMediator(originalRequest).getRemoteAddr();
        if (HttpRequestHelper.getFirstHeader("X-Forwarded-For", originalRequest) == null && this.isForwardedRequestHeader("X-Forwarded-For") && remoteAddr != null) {
            httpRequest.addHeader("X-Forwarded-For", remoteAddr);
        }
    }

    public void copyHeaders(HttpRequest httpRequest, HttpEntityEnclosingRequest originalRequest, HttpResponse httpClientResponse, HttpResponse output) throws MalformedURLException {
        String originalUri = originalRequest.getRequestLine().getUri();
        String uri = httpRequest.getRequestLine().getUri();
        for (Header header : httpClientResponse.getAllHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            try {
                if ("Content-Encoding".equalsIgnoreCase(name) || !this.isForwardedResponseHeader(name)) continue;
                if ("Location".equalsIgnoreCase(name) || "Content-Location".equalsIgnoreCase(name)) {
                    value = UriUtils.translateUrl(value, uri, originalUri);
                    value = HttpResponseUtils.removeSessionId(value, httpClientResponse);
                    output.addHeader(name, value);
                    continue;
                }
                if ("Link".equalsIgnoreCase(name)) {
                    if (value.startsWith("<") && value.contains(">")) {
                        String urlValue = value.substring(1, value.indexOf(">"));
                        String targetUrlValue = UriUtils.translateUrl(urlValue, uri, originalUri);
                        targetUrlValue = HttpResponseUtils.removeSessionId(targetUrlValue, httpClientResponse);
                        value = value.replace("<" + urlValue + ">", "<" + targetUrlValue + ">");
                    }
                    output.addHeader(name, value);
                    continue;
                }
                if ("Refresh".equalsIgnoreCase(name)) {
                    int urlPosition = value.indexOf("url=");
                    if (urlPosition >= 0) {
                        String urlValue = value.substring(urlPosition + 4);
                        String targetUrlValue = UriUtils.translateUrl(urlValue, uri, originalUri);
                        targetUrlValue = HttpResponseUtils.removeSessionId(targetUrlValue, httpClientResponse);
                        value = value.substring(0, urlPosition) + "url=" + targetUrlValue;
                    }
                    output.addHeader(name, value);
                    continue;
                }
                if ("P3p".equalsIgnoreCase(name)) {
                    output.addHeader(name, value);
                    continue;
                }
                output.addHeader(header.getName(), header.getValue());
            }
            catch (Exception e1) {
                LOG.error("Error while copying headers", (Throwable)e1);
                output.addHeader("X-Esigate-Error", "Error processing header " + name + ": " + value);
            }
        }
    }
}

