/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import org.apache.commons.io.IOUtils;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.ResourceContext;
import org.esigate.api.HttpRequest;
import org.esigate.xml.ProcessingFailedException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XsltRenderer
implements Renderer {
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private Transformer transformer;

    public XsltRenderer(String template, Driver driver, ResourceContext resourceContext) throws IOException, HttpErrorPage {
        try {
            InputStream templateStream = resourceContext.getOriginalRequest().getSession(true).getResourceTemplate(template);
            if (templateStream == null) {
                throw new ProcessingFailedException("Template " + template + " not found");
            }
            this.transformer = XsltRenderer.createTransformer(templateStream);
        }
        catch (Exception e) {
            this.transformer = XsltRenderer.createTransformer(IOUtils.toInputStream((String)driver.getResourceAsString(template, resourceContext)));
        }
    }

    public XsltRenderer(String template, HttpRequest request) throws IOException {
        InputStream templateStream = request.getSession(true).getResourceTemplate(template);
        if (templateStream == null) {
            throw new ProcessingFailedException("Template " + template + " not found");
        }
        this.transformer = XsltRenderer.createTransformer(templateStream);
    }

    public XsltRenderer(String xsl) throws IOException {
        InputStream templateStream = IOUtils.toInputStream((String)xsl);
        this.transformer = XsltRenderer.createTransformer(templateStream);
    }

    private static Transformer createTransformer(InputStream templateStream) throws IOException {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer(new StreamSource(templateStream));
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new ProcessingFailedException("Failed to create XSLT template", e);
        }
        finally {
            templateStream.close();
        }
    }

    public void render(ResourceContext requestContext, String src, Writer out) throws IOException {
        try {
            HtmlParser htmlParser = new HtmlParser(XmlViolationPolicy.ALLOW);
            htmlParser.setDoctypeExpectation(DoctypeExpectation.NO_DOCTYPE_ERRORS);
            SAXSource source = new SAXSource((XMLReader)htmlParser, new InputSource(new StringReader(src)));
            this.transformer.transform(source, new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new ProcessingFailedException("Failed to transform source", e);
        }
    }
}

