/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.esigate.ConfigurationException;
import org.esigate.DriverFactory;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.servlet.HttpRequestImpl;
import org.esigate.servlet.HttpResponseImpl;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 8479657871058986339L;
    private static Logger LOG = LoggerFactory.getLogger(RewriteProxyServlet.class);
    private final ArrayList<ReverseConfiguration> configuration = new ArrayList();

    private String getStringNotNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public void init(ServletConfig config) throws ServletException {
        TreeMap<String, ReverseConfiguration> confTree = new TreeMap<String, ReverseConfiguration>();
        InputStream propertiesInput = null;
        try {
            propertiesInput = RewriteProxyServlet.class.getResourceAsStream("/org/esigate/rewrite-proxy.properties");
            Properties properties = new Properties();
            properties.load(propertiesInput);
            propertiesInput.close();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String[] keySplitted = key.split("\\.");
                String rule = keySplitted[0];
                String attribute = keySplitted[1];
                String value = (String)entry.getValue();
                ReverseConfiguration currentConf = (ReverseConfiguration)confTree.get(rule);
                if (currentConf == null) {
                    currentConf = new ReverseConfiguration();
                }
                if ("provider".equals(attribute)) {
                    currentConf.setProvider(value);
                } else if ("pattern".equals(attribute)) {
                    currentConf.setUrlMatchPattern(Pattern.compile(value));
                } else if ("rewrite".equals(attribute)) {
                    currentConf.setUrlRewrite(value);
                } else if ("queryPattern".equals(attribute)) {
                    currentConf.setQueryMatchPattern(Pattern.compile(value));
                } else if ("queryRewrite".equals(attribute)) {
                    currentConf.setQueryRewrite(value);
                } else if ("schemePattern".equals(attribute)) {
                    currentConf.setSchemePattern(value);
                } else if ("schemeRewrite".equals(attribute)) {
                    currentConf.setSchemeRewrite(value);
                } else if ("redirect".equals(attribute)) {
                    currentConf.setRedirect(Integer.valueOf(value));
                } else if ("portPattern".equals(attribute)) {
                    currentConf.setPortPattern(Integer.valueOf(value));
                } else if ("portRewrite".equals(attribute)) {
                    currentConf.setPortRewrite(Integer.valueOf(value));
                }
                this.validateConfiguration(rule, currentConf);
                confTree.put(rule, currentConf);
            }
            this.configuration.addAll(confTree.values());
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (propertiesInput != null) {
                try {
                    propertiesInput.close();
                }
                catch (IOException e) {
                    LOG.error("failed to close stream", (Throwable)e);
                }
            }
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String relUrl = request.getRequestURI();
        relUrl = relUrl.substring(request.getContextPath().length());
        if (request.getServletPath() != null) {
            relUrl = relUrl.substring(request.getServletPath().length());
        }
        for (ReverseConfiguration conf : this.configuration) {
            Matcher urlMatcher = conf.getUrlMatchPattern().matcher(relUrl);
            if (!urlMatcher.matches()) continue;
            Matcher queryMatcher = null;
            if (conf.getQueryMatchPattern() != null) {
                queryMatcher = conf.getQueryMatchPattern().matcher(this.getStringNotNull(request.getQueryString()));
            }
            Boolean schemeMatcher = null;
            if (conf.getSchemePattern() != null) {
                schemeMatcher = conf.getSchemePattern().equals(request.getScheme());
            }
            Boolean portMatcher = null;
            if (conf.getPortPattern() != null) {
                portMatcher = conf.getPortPattern().equals(request.getServerPort());
            }
            if (queryMatcher != null && !queryMatcher.matches() || schemeMatcher != null && !schemeMatcher.booleanValue() || portMatcher != null && !portMatcher.booleanValue()) continue;
            String newUrl = relUrl;
            if (conf.getUrlRewrite() != null) {
                newUrl = conf.getUrlRewrite();
            }
            for (int i = 1; i < urlMatcher.groupCount() + 1; ++i) {
                newUrl = newUrl.replace("$" + i, urlMatcher.group(i));
            }
            String targetQueryString = null;
            if (queryMatcher != null) {
                targetQueryString = this.getStringNotNull(conf.getQueryRewrite());
                for (int i = 1; i < queryMatcher.groupCount() + 1; ++i) {
                    targetQueryString = targetQueryString.replace("$" + i, queryMatcher.group(i));
                }
                if ("".equals(targetQueryString)) {
                    targetQueryString = null;
                }
            } else {
                targetQueryString = request.getQueryString();
            }
            String targetScheme = null;
            targetScheme = schemeMatcher != null && conf.getSchemeRewrite() != null ? conf.getSchemeRewrite() : request.getScheme();
            Integer targetPort = null;
            targetPort = portMatcher != null && conf.getPortRewrite() != null ? conf.getPortRewrite() : Integer.valueOf(request.getServerPort());
            if (conf.getProvider() != null) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Proxying " + relUrl + " to " + newUrl + " w/ query " + targetQueryString);
                    }
                    DriverFactory.getInstance(conf.getProvider()).proxy(newUrl, HttpRequestImpl.wrap((HttpServletRequest)new ReverseHttpRequest(request, targetQueryString)), HttpResponseImpl.wrap(response), new Renderer[0]);
                    return;
                }
                catch (HttpErrorPage e) {
                    response.setStatus(e.getStatusCode());
                    response.getWriter().write(e.getErrorPageContent());
                    continue;
                }
            }
            String target = null;
            String targetFile = null;
            targetFile = targetQueryString != null ? newUrl + "?" + targetQueryString : newUrl;
            target = UriUtils.createURI(targetScheme, request.getServerName(), targetPort, targetFile, null, null).toString();
            int redirectCode = 301;
            if (conf.getRedirect() != null) {
                redirectCode = conf.getRedirect();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Redirecting " + relUrl + " to " + target + ". Code=" + redirectCode);
            }
            response.setStatus(redirectCode);
            response.setHeader("Location", target);
            return;
        }
    }

    private void validateConfiguration(String rule, ReverseConfiguration conf) {
        if (conf.getSchemePattern() != null && !conf.getSchemePattern().matches("http|https")) {
            ConfigurationException e = new ConfigurationException("Rule : " + rule + " had a none expected scheme pattern : " + conf.getSchemePattern() + " expected scheme pattern : http or https");
            throw e;
        }
        if (conf.getSchemeRewrite() != null && !conf.getSchemeRewrite().matches("http|https")) {
            ConfigurationException e = new ConfigurationException("Rule : " + rule + " had a none expected rewrite scheme : " + conf.getSchemeRewrite() + " expected rewrite scheme : http or https");
            throw e;
        }
        if (conf.getRedirect() != null && (conf.getRedirect() < 300 || conf.getRedirect() > 400)) {
            ConfigurationException e = new ConfigurationException("Rule : " + rule + " had a none expected redirect code range : " + conf.getRedirect() + " expected range : 300-400");
            throw e;
        }
    }

    private static class ReverseHttpRequest
    extends HttpServletRequestWrapper {
        private final String queryString;

        public ReverseHttpRequest(HttpServletRequest request, String queryString) {
            super(request);
            this.queryString = queryString;
        }

        public String getQueryString() {
            return this.queryString;
        }
    }

    private static class ReverseConfiguration {
        private Pattern urlMatchPattern;
        private String provider;
        private Pattern queryMatchPattern;
        private String queryRewrite;
        private String urlRewrite;
        private String schemePattern;
        private String schemeRewrite;
        private Integer redirect;
        private Integer portPattern;
        private Integer portRewrite;

        private ReverseConfiguration() {
        }

        public Integer getPortPattern() {
            return this.portPattern;
        }

        public Integer getPortRewrite() {
            return this.portRewrite;
        }

        public String getProvider() {
            return this.provider;
        }

        public Pattern getQueryMatchPattern() {
            return this.queryMatchPattern;
        }

        public String getQueryRewrite() {
            return this.queryRewrite;
        }

        public Integer getRedirect() {
            return this.redirect;
        }

        public String getSchemePattern() {
            return this.schemePattern;
        }

        public String getSchemeRewrite() {
            return this.schemeRewrite;
        }

        public Pattern getUrlMatchPattern() {
            return this.urlMatchPattern;
        }

        public String getUrlRewrite() {
            return this.urlRewrite;
        }

        public void setPortPattern(Integer portPattern) {
            this.portPattern = portPattern;
        }

        public void setPortRewrite(Integer portRewrite) {
            this.portRewrite = portRewrite;
        }

        public void setProvider(String provider) {
            this.provider = provider;
        }

        public void setQueryMatchPattern(Pattern queryMatchPattern) {
            this.queryMatchPattern = queryMatchPattern;
        }

        public void setQueryRewrite(String queryRewrite) {
            this.queryRewrite = queryRewrite;
        }

        public void setRedirect(Integer redirect) {
            this.redirect = redirect;
        }

        public void setSchemePattern(String schemePattern) {
            this.schemePattern = schemePattern;
        }

        public void setSchemeRewrite(String schemeRewrite) {
            this.schemeRewrite = schemeRewrite;
        }

        public void setUrlMatchPattern(Pattern matchPattern) {
            this.urlMatchPattern = matchPattern;
        }

        public void setUrlRewrite(String rewrite) {
            this.urlRewrite = rewrite;
        }
    }
}

