/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.esigate.api.Cookie;
import org.esigate.api.HttpRequest;
import org.esigate.cookie.BasicClientCookie;
import org.esigate.servlet.HttpSessionImpl;
import org.esigate.util.UriUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestImpl
implements HttpRequest {
    private final HttpServletRequest parent;
    private Long ttl;
    private Integer maxWait;
    private boolean noStore;

    private HttpRequestImpl(HttpServletRequest parent) {
        this.parent = parent;
    }

    public static HttpRequest wrap(HttpServletRequest parent) {
        return new HttpRequestImpl(parent);
    }

    public String getQueryString() {
        return this.parent.getQueryString();
    }

    @Override
    public String getParameter(String name) {
        return this.parent.getParameter(name);
    }

    @Override
    public String getHeader(String name) {
        return this.parent.getHeader(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return Collections.list(this.parent.getHeaderNames());
    }

    @Override
    public Cookie[] getCookies() {
        javax.servlet.http.Cookie[] src = this.parent.getCookies();
        Cookie[] result = null;
        if (src != null) {
            result = new Cookie[src.length];
            for (int i = 0; i < src.length; ++i) {
                javax.servlet.http.Cookie c = src[i];
                BasicClientCookie dest = new BasicClientCookie(c.getName(), c.getValue());
                dest.setSecure(c.getSecure());
                dest.setDomain(c.getDomain());
                dest.setPath(c.getPath());
                dest.setComment(c.getComment());
                dest.setVersion(c.getVersion());
                result[i] = dest;
            }
        }
        return result;
    }

    @Override
    public String getMethod() {
        return this.parent.getMethod();
    }

    public int getServerPort() {
        return this.parent.getServerPort();
    }

    public String getServerName() {
        return this.parent.getServerName();
    }

    public String getScheme() {
        return this.parent.getScheme();
    }

    @Override
    public String getRemoteAddr() {
        return this.parent.getRemoteAddr();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.parent.getInputStream();
    }

    @Override
    public String getContentType() {
        return this.parent.getContentType();
    }

    public String getRequestURI() {
        return this.parent.getRequestURI();
    }

    public String getRequestURL() {
        return this.parent.getRequestURL().toString();
    }

    @Override
    public boolean isSecure() {
        return this.parent.isSecure();
    }

    @Override
    public String getCharacterEncoding() {
        return this.parent.getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.parent.setCharacterEncoding(env);
    }

    @Override
    public String getRemoteUser() {
        return this.parent.getRemoteUser();
    }

    @Override
    public Object getAttribute(String name) {
        return this.parent.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object o) {
        this.parent.setAttribute(name, o);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.parent.getUserPrincipal();
    }

    @Override
    public org.esigate.api.HttpSession getSession(boolean create) {
        HttpSession session = this.parent.getSession(create);
        return session != null ? HttpSessionImpl.wrap(session) : null;
    }

    @Override
    public Long getResourceTtl() {
        return this.ttl;
    }

    @Override
    public Boolean isNoStoreResource() {
        return this.noStore;
    }

    @Override
    public Integer getFetchMaxWait() {
        return this.maxWait;
    }

    @Override
    public void setResourceTtl(Long ttl) {
        this.ttl = ttl;
    }

    @Override
    public void setNoStoreResource(boolean noStore) {
        this.noStore = noStore;
    }

    @Override
    public void setFetchMaxWait(Integer maxWait) {
        this.maxWait = maxWait;
    }

    @Override
    public URI getUri() {
        return UriUtils.createURI(this.parent.getScheme(), this.parent.getServerName(), this.parent.getServerPort(), this.parent.getRequestURI(), this.parent.getQueryString(), null);
    }
}

