/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.esigate.ResourceContext;
import org.esigate.api.HttpSession;
import org.esigate.util.UriUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    private ResourceUtils() {
    }

    private static final String buildQueryString(ResourceContext target, boolean proxy) {
        try {
            StringBuilder queryString = new StringBuilder();
            String charset = target.getOriginalRequest().getCharacterEncoding();
            if (charset == null) {
                charset = "ISO-8859-1";
            }
            String originalQuerystring = target.getOriginalRequest().getUri().getRawQuery();
            if (proxy && originalQuerystring != null) {
                String jsessionid = null;
                HttpSession session = target.getOriginalRequest().getSession(false);
                if (session != null) {
                    jsessionid = session.getId();
                }
                if (jsessionid != null) {
                    originalQuerystring = UriUtils.removeSessionId(jsessionid, originalQuerystring);
                }
                queryString.append(originalQuerystring);
            }
            if (target.getParameters() != null) {
                ResourceUtils.appendParameters(queryString, charset, target.getParameters());
            }
            return queryString.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void appendParameters(StringBuilder buf, String charset, Map<String, String> params) throws UnsupportedEncodingException {
        for (Map.Entry<String, String> param : params.entrySet()) {
            if (buf.length() > 0) {
                buf.append("&");
            }
            buf.append(URLEncoder.encode(param.getKey(), charset));
            buf.append("=");
            buf.append(URLEncoder.encode(param.getValue(), charset));
        }
    }

    private static final String concatUrl(String baseUrl, String relUrl) {
        StringBuilder url = new StringBuilder();
        if (baseUrl != null && relUrl != null && (baseUrl.endsWith("/") || baseUrl.endsWith("\\")) && relUrl.startsWith("/")) {
            url.append(baseUrl.substring(0, baseUrl.length() - 1)).append(relUrl);
        } else {
            url.append(baseUrl).append(relUrl);
        }
        return url.toString();
    }

    public static final String getHttpUrlWithQueryString(ResourceContext target, boolean proxy) {
        String queryString;
        String url = target.getRelUrl();
        if (!url.startsWith("http://") && !url.startsWith("https://") && target.getBaseURL() != null) {
            url = ResourceUtils.concatUrl(target.getBaseURL(), url);
        }
        if ((queryString = ResourceUtils.buildQueryString(target, proxy)).length() == 0) {
            return url;
        }
        return url + "?" + queryString;
    }
}

