/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseUtils.class);

    public static boolean isError(HttpResponse httpResponse) {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        return statusCode != 200 && statusCode != 302 && statusCode != 301 && statusCode != 304;
    }

    public static String getFirstHeader(String headerName, HttpResponse httpResponse) {
        Header header = httpResponse.getFirstHeader(headerName);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public static String getContentCharset(HttpResponse httpResponse) {
        Charset charset;
        ContentType contentType = ContentType.get((HttpEntity)httpResponse.getEntity());
        if (contentType != null && (charset = contentType.getCharset()) != null) {
            return charset.name();
        }
        return null;
    }

    public static void release(HttpResponse httpResponse) {
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            try {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
            catch (IOException e) {
                LOG.debug("Could not release request. Usualy this is due to a client abort.");
            }
        }
    }
}

