/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.params.ClientParamBean;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.esigate.ConfigurationException;
import org.esigate.HttpErrorPage;
import org.esigate.Parameters;
import org.esigate.api.HttpResponse;
import org.esigate.cache.CacheConfigHelper;
import org.esigate.extension.Extension;
import org.esigate.http.GenericHttpRequest;
import org.esigate.http.HttpResponseUtils;
import org.esigate.http.RedirectStrategy;
import org.esigate.http.UnsupportedContentEncodingException;
import org.esigate.http.UnsupportedHttpMethodException;
import org.esigate.util.FilterList;
import org.esigate.util.PropertiesUtil;
import org.esigate.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientHelper
implements Extension {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientHelper.class);
    private static final Set<String> SIMPLE_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS", "TRACE", "DELETE")));
    private static final Set<String> ENTITY_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("POST", "PUT", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK")));
    private boolean preserveHost;
    private FilterList requestHeadersFilterList;
    private FilterList responseHeadersFilterList;
    private HttpClient httpClient;
    private HttpHost proxyHost;
    private Credentials proxyCredentials;

    protected void init(HttpClient defaultHttpClient, Properties properties) {
        boolean useCache = Parameters.USE_CACHE.getValueBoolean(properties);
        this.httpClient = useCache ? CacheConfigHelper.addCache(properties, defaultHttpClient) : defaultHttpClient;
        this.preserveHost = Parameters.PRESERVE_HOST.getValueBoolean(properties);
        this.requestHeadersFilterList = new FilterList();
        this.responseHeadersFilterList = new FilterList();
        this.requestHeadersFilterList.add(Collections.singletonList("*"));
        this.responseHeadersFilterList.add(Collections.singletonList("*"));
        PropertiesUtil.populate(this.requestHeadersFilterList, properties, Parameters.FORWARD_REQUEST_HEADERS.name, Parameters.DISCARD_REQUEST_HEADERS.name, "", Parameters.DISCARD_REQUEST_HEADERS.defaultValue);
        PropertiesUtil.populate(this.responseHeadersFilterList, properties, Parameters.FORWARD_RESPONSE_HEADERS.name, Parameters.DISCARD_RESPONSE_HEADERS.name, "", Parameters.DISCARD_RESPONSE_HEADERS.defaultValue);
    }

    public void init(Properties properties) {
        String proxyHostParameter = Parameters.PROXY_HOST.getValueString(properties);
        if (proxyHostParameter != null) {
            int proxyPort = Parameters.PROXY_PORT.getValueInt(properties);
            this.proxyHost = new HttpHost(proxyHostParameter, proxyPort);
            String proxyUser = Parameters.PROXY_USER.getValueString(properties);
            if (proxyUser != null) {
                String proxyPassword = Parameters.PROXY_PASSWORD.getValueString(properties);
                this.proxyCredentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            }
        }
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            SSLSocketFactory sslSocketFactory = new SSLSocketFactory(sslContext, SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
            Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory);
            schemeRegistry.register(https);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConfigurationException(e);
        }
        catch (KeyManagementException e) {
            throw new ConfigurationException(e);
        }
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(schemeRegistry);
        connectionManager.setMaxTotal(Parameters.MAX_CONNECTIONS_PER_HOST.getValueInt(properties));
        connectionManager.setDefaultMaxPerRoute(Parameters.MAX_CONNECTIONS_PER_HOST.getValueInt(properties));
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)Parameters.CONNECT_TIMEOUT.getValueInt(properties));
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)Parameters.SOCKET_TIMEOUT.getValueInt(properties));
        httpParams.setBooleanParameter("http.protocol.allow-circular-redirects", true);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpParams);
        defaultHttpClient.setRedirectStrategy((org.apache.http.client.RedirectStrategy)new RedirectStrategy());
        if (this.proxyHost != null) {
            if (this.proxyCredentials != null) {
                defaultHttpClient.getCredentialsProvider().setCredentials(new AuthScope(this.proxyHost.getHostName(), this.proxyHost.getPort()), this.proxyCredentials);
            }
            defaultHttpClient.getParams().setParameter("http.route.default-proxy", (Object)this.proxyHost);
        }
        this.init((HttpClient)defaultHttpClient, properties);
    }

    protected boolean isForwardedRequestHeader(String headerName) {
        return this.requestHeadersFilterList.contains(headerName);
    }

    protected boolean isForwardedResponseHeader(String headerName) {
        return this.responseHeadersFilterList.contains(headerName);
    }

    public GenericHttpRequest createHttpRequest(org.esigate.api.HttpRequest originalRequest, String uri, boolean proxy) throws HttpErrorPage {
        GenericHttpRequest httpRequest;
        String method;
        HttpHost uriHost;
        HttpHost targetHost = uriHost = UriUtils.extractHost(UriUtils.createUri(uri));
        HttpHost virtualHost = null;
        HttpRoute route = null;
        if (this.preserveHost) {
            targetHost = virtualHost = UriUtils.extractHost(originalRequest.getUri());
            route = this.proxyHost == null ? new HttpRoute(uriHost) : new HttpRoute(uriHost, null, this.proxyHost, false);
            uri = UriUtils.rewriteURI(uri, targetHost).toString();
        }
        String string = method = proxy ? originalRequest.getMethod().toUpperCase() : "GET";
        if (SIMPLE_METHODS.contains(method)) {
            httpRequest = new GenericHttpRequest(method, uri);
        } else if (ENTITY_METHODS.contains(method)) {
            InputStreamEntity inputStreamEntity;
            GenericHttpRequest result = new GenericHttpRequest(method, uri);
            long contentLength = originalRequest.getHeader("Content-Length") != null ? Long.parseLong(originalRequest.getHeader("Content-Length")) : -1L;
            try {
                inputStreamEntity = new InputStreamEntity(originalRequest.getInputStream(), contentLength);
            }
            catch (IOException e) {
                throw new HttpErrorPage(400, "Bad request", e);
            }
            if (originalRequest.getContentType() != null) {
                inputStreamEntity.setContentType(originalRequest.getContentType());
            }
            if (originalRequest.getHeader("Content-Encoding") != null) {
                inputStreamEntity.setContentEncoding(originalRequest.getHeader("Content-Encoding"));
            }
            result.setEntity((HttpEntity)inputStreamEntity);
            httpRequest = result;
        } else {
            throw new UnsupportedHttpMethodException(method + " " + uri);
        }
        httpRequest.getParams().setParameter("http.protocol.handle-redirects", (Object)(!proxy ? 1 : 0));
        httpRequest.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        Integer maxWait = originalRequest.getFetchMaxWait();
        if (maxWait != null) {
            HttpConnectionParams.setSoTimeout((HttpParams)httpRequest.getParams(), (int)maxWait);
        }
        this.copyHeaders(originalRequest, (HttpRequest)httpRequest);
        if (virtualHost != null) {
            ClientParamBean clientParamBean = new ClientParamBean(httpRequest.getParams());
            clientParamBean.setVirtualHost(virtualHost);
            httpRequest.getParams().setParameter("http.route.forced-route", (Object)route);
        }
        return httpRequest;
    }

    private void copyHeaders(org.esigate.api.HttpRequest originalRequest, HttpRequest httpRequest) throws HttpErrorPage {
        String originalUri = originalRequest.getUri().toString();
        String uri = httpRequest.getRequestLine().getUri();
        for (String name : originalRequest.getHeaderNames()) {
            String value;
            if ("User-Agent".equalsIgnoreCase(name) && this.isForwardedRequestHeader("User-Agent")) {
                httpRequest.getParams().setParameter("http.useragent", (Object)originalRequest.getHeader(name));
                continue;
            }
            if ("Referer".equalsIgnoreCase(name) && this.isForwardedRequestHeader("Referer")) {
                value = originalRequest.getHeader(name);
                try {
                    value = UriUtils.translateUrl(value, originalUri, uri);
                }
                catch (MalformedURLException e) {
                    throw new HttpErrorPage(400, "Bad request", e);
                }
                httpRequest.addHeader(name, value);
                continue;
            }
            if (!this.isForwardedRequestHeader(name) || (value = originalRequest.getHeader(name)) == null) continue;
            httpRequest.addHeader(name, value);
        }
        if (originalRequest.getHeader("X-Forwarded-For") == null && this.isForwardedRequestHeader("X-Forwarded-For") && originalRequest.getRemoteAddr() != null) {
            httpRequest.addHeader("X-Forwarded-For", originalRequest.getRemoteAddr());
        }
    }

    private void copyHeaders(org.apache.http.HttpResponse httpClientResponse, HttpResponse output, org.esigate.api.HttpRequest originalRequest, HttpRequest httpRequest) throws MalformedURLException {
        String originalUri = originalRequest.getUri().toString();
        String uri = httpRequest.getRequestLine().getUri();
        for (Header header : httpClientResponse.getAllHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            if (!this.isForwardedResponseHeader(name)) continue;
            if ("Location".equalsIgnoreCase(name) || "Content-Location".equalsIgnoreCase(name) || "Link".equalsIgnoreCase(name) || "P3p".equalsIgnoreCase(name)) {
                value = UriUtils.translateUrl(value, uri, originalUri);
                value = this.removeSessionId(value, httpClientResponse);
                output.addHeader(name, value);
                continue;
            }
            if ("Content-Encoding".equalsIgnoreCase(name)) continue;
            output.addHeader(header.getName(), header.getValue());
        }
    }

    private String removeSessionId(String src, org.apache.http.HttpResponse httpResponse) {
        BrowserCompatSpec cookieSpec = new BrowserCompatSpec();
        CookieOrigin cookieOrigin = new CookieOrigin("dummy", 80, "/", false);
        Header[] responseHeaders = httpResponse.getHeaders("Set-cookie");
        String jsessionid = null;
        for (int i = 0; i < responseHeaders.length; ++i) {
            Header header = responseHeaders[i];
            try {
                Cookie cookie;
                List cookies = cookieSpec.parse(header, cookieOrigin);
                Iterator i$ = cookies.iterator();
                if (i$.hasNext() && "JSESSIONID".equalsIgnoreCase((cookie = (Cookie)i$.next()).getName())) {
                    jsessionid = cookie.getValue();
                }
            }
            catch (MalformedCookieException ex) {
                LOG.warn("Malformed header: " + header.getName() + ": " + header.getValue());
            }
            if (jsessionid != null) break;
        }
        if (jsessionid == null) {
            return src;
        }
        return UriUtils.removeSessionId(jsessionid, src);
    }

    public org.apache.http.HttpResponse execute(HttpRequest httpRequest, HttpContext httpContext) {
        try {
            HttpHost httpHost = UriUtils.extractHost(httpRequest.getRequestLine().getUri());
            org.apache.http.HttpResponse httpResponse = this.httpClient.execute(httpHost, httpRequest, httpContext);
            HttpRequest lastRequest = RedirectStrategy.getLastRequest(httpRequest, httpContext);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode == 200 || statusCode == 304) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(lastRequest.getRequestLine() + " -> " + httpResponse.getStatusLine());
                }
            } else if (statusCode == 302 || statusCode == 301) {
                if (LOG.isInfoEnabled()) {
                    Header locationHeader = httpResponse.getFirstHeader("Location");
                    String location = "";
                    if (locationHeader != null) {
                        location = locationHeader.getValue();
                    }
                    LOG.info(lastRequest.getRequestLine() + " -> " + httpResponse.getStatusLine() + " Location: " + location);
                }
            } else if (LOG.isWarnEnabled()) {
                LOG.warn(lastRequest.getRequestLine() + " -> " + httpResponse.getStatusLine());
            }
            return httpResponse;
        }
        catch (HttpHostConnectException e) {
            int statusCode = 502;
            String statusText = "Connection refused";
            LOG.error(httpRequest.getRequestLine() + " -> " + statusCode + " " + statusText, (Throwable)e);
            return new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusText));
        }
        catch (ConnectionPoolTimeoutException e) {
            int statusCode = 504;
            String statusText = "Connection pool timeout";
            LOG.error(httpRequest.getRequestLine() + " -> " + statusCode + " " + statusText, (Throwable)e);
            return new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusText));
        }
        catch (ConnectTimeoutException e) {
            int statusCode = 504;
            String statusText = "Connect timeout";
            LOG.error(httpRequest.getRequestLine() + " -> " + statusCode + " " + statusText, (Throwable)e);
            return new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusText));
        }
        catch (SocketTimeoutException e) {
            int statusCode = 504;
            String statusText = "Socket timeout";
            LOG.error(httpRequest.getRequestLine() + " -> " + statusCode + " " + statusText, (Throwable)e);
            return new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusText));
        }
        catch (IOException e) {
            int statusCode = 500;
            String statusText = "Error retrieving URL";
            LOG.error(httpRequest.getRequestLine() + " -> " + statusCode + " " + statusText, (Throwable)e);
            return new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, statusText));
        }
    }

    public HttpContext createHttpContext(CookieStore cookieStore) {
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
        return httpContext;
    }

    public void render(org.apache.http.HttpResponse httpResponse, HttpResponse output, org.esigate.api.HttpRequest originalRequest, HttpRequest request) throws IOException {
        String contentEncoding = HttpResponseUtils.getFirstHeader("Content-Encoding", httpResponse);
        if (contentEncoding != null) {
            output.addHeader("Content-Encoding", contentEncoding);
        }
        this.render(httpResponse.getEntity(), httpResponse, output, originalRequest, request);
    }

    public void render(String transformedEntity, org.apache.http.HttpResponse httpResponse, HttpResponse output, org.esigate.api.HttpRequest originalRequest, HttpRequest request) throws IOException {
        StringEntity httpEntity = new StringEntity(transformedEntity, ContentType.get((HttpEntity)httpResponse.getEntity()));
        this.render((HttpEntity)httpEntity, httpResponse, output, originalRequest, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(HttpEntity transformedEntity, org.apache.http.HttpResponse httpResponse, HttpResponse output, org.esigate.api.HttpRequest originalRequest, HttpRequest request) throws IOException {
        output.setStatus(httpResponse.getStatusLine().getStatusCode());
        this.copyHeaders(httpResponse, output, originalRequest, request);
        if (transformedEntity == null) {
            return;
        }
        InputStream content = transformedEntity.getContent();
        try {
            IOUtils.copy((InputStream)content, (OutputStream)output.getOutputStream());
        }
        finally {
            content.close();
        }
    }

    public String toString(org.apache.http.HttpResponse httpResponse) throws IOException {
        String result;
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            result = httpResponse.getStatusLine().getReasonPhrase();
        } else {
            String contentEncoding = HttpResponseUtils.getFirstHeader("Content-Encoding", httpResponse);
            if (contentEncoding != null) {
                if ("gzip".equalsIgnoreCase(contentEncoding) || "x-gzip".equalsIgnoreCase(contentEncoding)) {
                    httpEntity = new GzipDecompressingEntity(httpEntity);
                } else if ("deflate".equalsIgnoreCase(contentEncoding)) {
                    httpEntity = new DeflateDecompressingEntity(httpEntity);
                } else {
                    throw new UnsupportedContentEncodingException("Content-encoding \"" + contentEncoding + "\" is not supported");
                }
            }
            result = EntityUtils.toString((HttpEntity)httpEntity);
        }
        return this.removeSessionId(result, httpResponse);
    }
}

