/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.esi;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;
import org.esigate.HttpErrorPage;
import org.esigate.Renderer;
import org.esigate.ResourceContext;
import org.esigate.esi.FragmentElement;
import org.esigate.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsiFragmentRenderer
implements Renderer,
Appendable {
    private static final Logger LOG = LoggerFactory.getLogger(EsiFragmentRenderer.class);
    private static final Pattern PATTERN = Pattern.compile("(<esi:[^>]*>)|(</esi:[^>]*>)");
    private final Parser parser = new Parser(PATTERN, FragmentElement.TYPE);
    private final String page;
    private final String name;
    private boolean write;
    private Writer out;

    public void setWrite(boolean write) {
        this.write = write;
    }

    public String getName() {
        return this.name;
    }

    public EsiFragmentRenderer(String page, String name) {
        this.page = page;
        this.name = name;
        this.write = false;
    }

    public void render(ResourceContext requestContext, String content, Writer out) throws IOException, HttpErrorPage {
        LOG.debug("Rendering fragment " + this.name + " in page " + this.page);
        this.out = out;
        if (content == null) {
            return;
        }
        this.parser.parse(content, this);
    }

    public Appendable append(CharSequence csq) throws IOException {
        if (this.write) {
            this.out.append(csq);
        }
        return this;
    }

    public Appendable append(char c) throws IOException {
        if (this.write) {
            this.out.append(c);
        }
        return this;
    }

    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        if (this.write) {
            this.out.append(csq, start, end);
        }
        return this;
    }
}

