/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.http.protocol.HttpContext;
import org.esigate.DriverConfiguration;
import org.esigate.HttpErrorPage;
import org.esigate.Parameters;
import org.esigate.Renderer;
import org.esigate.ResourceContext;
import org.esigate.UserContext;
import org.esigate.api.HttpRequest;
import org.esigate.api.HttpResponse;
import org.esigate.authentication.AuthenticationHandler;
import org.esigate.cookie.CookieManager;
import org.esigate.extension.ExtensionFactory;
import org.esigate.filter.Filter;
import org.esigate.http.GenericHttpRequest;
import org.esigate.http.HttpClientHelper;
import org.esigate.http.HttpResponseUtils;
import org.esigate.http.RequestCookieStore;
import org.esigate.http.ResourceUtils;
import org.esigate.regexp.ReplaceRenderer;
import org.esigate.renderers.ResourceFixupRenderer;
import org.esigate.tags.BlockRenderer;
import org.esigate.tags.TemplateRenderer;
import org.esigate.vars.VariablesResolver;
import org.esigate.xml.XpathRenderer;
import org.esigate.xml.XsltRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Driver {
    private static final Logger LOG = LoggerFactory.getLogger(Driver.class);
    private final DriverConfiguration config;
    private final AuthenticationHandler authenticationHandler;
    private final Filter filter;
    private final HttpClientHelper httpClientHelper;
    private final List<String> parsableContentTypes;
    private final CookieManager cookieManager;

    public Driver(String name, Properties props) {
        this(name, props, new HttpClientHelper());
        this.httpClientHelper.init(props);
    }

    public Driver(String name, Properties props, HttpClientHelper httpClientHelper) {
        this.config = new DriverConfiguration(name, props);
        this.httpClientHelper = httpClientHelper;
        this.authenticationHandler = ExtensionFactory.getExtension(props, Parameters.AUTHENTICATION_HANDLER, AuthenticationHandler.class);
        Filter f = ExtensionFactory.getExtension(props, Parameters.FILTER, Filter.class);
        this.filter = f != null ? f : Filter.EMPTY;
        this.parsableContentTypes = new ArrayList<String>();
        String strContentTypes = Parameters.PARSABLE_CONTENT_TYPES.getValueString(props);
        StringTokenizer tokenizer = new StringTokenizer(strContentTypes, ",");
        while (tokenizer.hasMoreElements()) {
            String contentType = tokenizer.nextToken();
            contentType = contentType.trim();
            this.parsableContentTypes.add(contentType);
        }
        this.cookieManager = ExtensionFactory.getExtension(props, Parameters.COOKIE_MANAGER, CookieManager.class);
    }

    public final UserContext getUserContext(HttpRequest httpRequest) {
        return new UserContext(httpRequest, this.config.getInstanceName());
    }

    public final void renderXml(String source, String template, Appendable out, HttpRequest request, HttpResponse response, Map<String, String> replaceRules) throws IOException, HttpErrorPage {
        LOG.info("renderXml provider=" + this.config.getInstanceName() + " source=" + source + " template=" + template);
        this.render(source, null, out, request, response, new XsltRenderer(template, request), new ReplaceRenderer(replaceRules));
    }

    public final void renderXpath(String source, String xpath, Appendable out, HttpRequest request, HttpResponse response, Map<String, String> replaceRules) throws IOException, HttpErrorPage {
        LOG.info("renderXpath provider=" + this.config.getInstanceName() + " source=" + source + " xpath=" + xpath);
        this.render(source, null, out, request, response, new XpathRenderer(xpath), new ReplaceRenderer(replaceRules));
    }

    public final ResourceContext renderBlock(String page, String name, Appendable writer, HttpRequest request, HttpResponse response, Map<String, String> replaceRules, Map<String, String> parameters, boolean copyOriginalRequestParameters) throws IOException, HttpErrorPage {
        LOG.info("renderBlock provider=" + this.config.getInstanceName() + " page=" + page + " name=" + name);
        return this.render(page, parameters, writer, request, response, new BlockRenderer(name, page), new ReplaceRenderer(replaceRules));
    }

    public final void renderTemplate(String page, String name, Appendable writer, HttpRequest request, HttpResponse response, Map<String, String> params, Map<String, String> replaceRules, Map<String, String> parameters, boolean propagateJsessionId) throws IOException, HttpErrorPage {
        LOG.info("renderTemplate provider=" + this.config.getInstanceName() + " page=" + page + " name=" + name);
        this.render(page, parameters, writer, request, response, new TemplateRenderer(name, params, page), new ReplaceRenderer(replaceRules));
    }

    public final void renderEsi(String page, Appendable writer, HttpRequest request, HttpResponse response) throws IOException, HttpErrorPage {
        this.render(page, null, writer, request, response, new Renderer[0]);
    }

    public final void render(String page, Appendable writer, ResourceContext parent, Renderer ... renderers) throws IOException, HttpErrorPage {
        this.render(page, parent.getParameters(), writer, parent.getOriginalRequest(), parent.getOriginalResponse(), renderers);
    }

    private final ResourceContext render(String page, Map<String, String> parameters, Appendable writer, HttpRequest request, HttpResponse response, Renderer ... renderers) throws IOException, HttpErrorPage {
        if (LOG.isInfoEnabled()) {
            ArrayList<String> rendererNames = new ArrayList<String>(renderers.length);
            for (Renderer renderer : renderers) {
                rendererNames.add(renderer.getClass().getName());
            }
            LOG.info("render provider={} page= {} renderers={}", new Object[]{this.config.getInstanceName(), page, rendererNames});
        }
        String resultingpage = VariablesResolver.replaceAllVariables(page, request);
        ResourceContext resourceContext = new ResourceContext(this, resultingpage, parameters, request, response);
        String currentValue = this.getResourceAsString(resourceContext);
        if (this.config.isFixResources()) {
            ResourceFixupRenderer fixup = new ResourceFixupRenderer(resourceContext.getBaseURL(), this.config.getVisibleBaseURL(resourceContext.getBaseURL()), page, this.config.getFixMode());
            StringWriter stringWriter = new StringWriter();
            fixup.render(resourceContext, currentValue, stringWriter);
            currentValue = stringWriter.toString();
        }
        for (Renderer renderer : renderers) {
            StringWriter stringWriter = new StringWriter();
            renderer.render(resourceContext, currentValue, stringWriter);
            currentValue = stringWriter.toString();
        }
        writer.append(currentValue);
        return resourceContext;
    }

    public void proxy(String relUrl, HttpRequest request, HttpResponse response, Renderer ... renderers) throws IOException, HttpErrorPage {
        String url;
        LOG.info("proxy provider={} relUrl={}", (Object)this.config.getInstanceName(), (Object)relUrl);
        ResourceContext resourceContext = new ResourceContext(this, relUrl, null, request, response);
        request.setCharacterEncoding(this.config.getUriEncoding());
        if (!this.authenticationHandler.beforeProxy(resourceContext)) {
            return;
        }
        HttpRequest originalRequest = resourceContext.getOriginalRequest();
        GenericHttpRequest httpRequest = this.httpClientHelper.createHttpRequest(originalRequest, url = ResourceUtils.getHttpUrlWithQueryString(resourceContext, true), true);
        org.apache.http.HttpResponse httpResponse = this.execute(httpRequest, originalRequest, resourceContext);
        if (HttpResponseUtils.isError(httpResponse)) {
            String errorPageContent = this.httpClientHelper.toString(httpResponse);
            throw new HttpErrorPage(httpResponse.getStatusLine().getStatusCode(), httpResponse.getStatusLine().getReasonPhrase(), errorPageContent);
        }
        if (!this.isTextContentType(httpResponse)) {
            LOG.debug("'" + relUrl + "' is binary on no transformation to apply: was forwarded without modification.");
            this.httpClientHelper.render(httpResponse, response, originalRequest, (org.apache.http.HttpRequest)httpRequest);
        } else {
            LOG.debug("'" + relUrl + "' is text : will apply renderers.");
            String currentValue = this.httpClientHelper.toString(httpResponse);
            ArrayList<Renderer> listOfRenderers = new ArrayList<Renderer>(renderers.length + 1);
            if (this.config.isFixResources()) {
                ResourceFixupRenderer fixup = new ResourceFixupRenderer(resourceContext.getBaseURL(), this.config.getVisibleBaseURL(resourceContext.getBaseURL()), relUrl, this.config.getFixMode());
                listOfRenderers.add(fixup);
            }
            listOfRenderers.addAll(Arrays.asList(renderers));
            for (Renderer renderer : listOfRenderers) {
                StringWriter stringWriter = new StringWriter();
                renderer.render(resourceContext, currentValue, stringWriter);
                currentValue = stringWriter.toString();
            }
            String charsetName = HttpResponseUtils.getContentCharset(httpResponse);
            if (charsetName == null) {
                charsetName = "ISO-8859-1";
            }
            this.httpClientHelper.render(currentValue, httpResponse, response, originalRequest, (org.apache.http.HttpRequest)httpRequest);
        }
    }

    protected String getResourceAsString(ResourceContext context) throws HttpErrorPage, IOException {
        String result;
        String url = ResourceUtils.getHttpUrlWithQueryString(context, false);
        HttpRequest request = context.getOriginalRequest();
        boolean cacheable = "GET".equalsIgnoreCase(context.getOriginalRequest().getMethod());
        if (cacheable && (result = (String)request.getAttribute(url)) != null) {
            return result;
        }
        HttpRequest originalRequest = context.getOriginalRequest();
        GenericHttpRequest httpRequest = this.httpClientHelper.createHttpRequest(originalRequest, url, false);
        org.apache.http.HttpResponse httpResponse = this.execute(httpRequest, originalRequest, context);
        result = this.httpClientHelper.toString(httpResponse);
        if (HttpResponseUtils.isError(httpResponse)) {
            throw new HttpErrorPage(httpResponse.getStatusLine().getStatusCode(), httpResponse.getStatusLine().getReasonPhrase(), result);
        }
        if (cacheable) {
            request.setAttribute(url, result);
        }
        return result;
    }

    public String getResourceAsString(String page, ResourceContext ctx) throws HttpErrorPage, IOException {
        String actualPage = VariablesResolver.replaceAllVariables(page, ctx.getOriginalRequest());
        ResourceContext resourceContext = new ResourceContext(this, actualPage, null, ctx.getOriginalRequest(), ctx.getOriginalResponse());
        String currentValue = this.getResourceAsString(resourceContext);
        return currentValue;
    }

    public DriverConfiguration getConfiguration() {
        return this.config;
    }

    private boolean isTextContentType(org.apache.http.HttpResponse httpResponse) {
        String contentType = HttpResponseUtils.getFirstHeader("Content-Type", httpResponse);
        return this.isTextContentType(contentType);
    }

    protected boolean isTextContentType(String contentType) {
        if (contentType != null) {
            String lowerContentType = contentType.toLowerCase();
            for (String textContentType : this.parsableContentTypes) {
                if (!lowerContentType.startsWith(textContentType)) continue;
                return true;
            }
        }
        return false;
    }

    private org.apache.http.HttpResponse executeSingleRequest(GenericHttpRequest httpRequest, HttpContext httpContext, ResourceContext resourceContext) {
        this.filter.preRequest(httpRequest, httpContext, resourceContext);
        this.authenticationHandler.preRequest(httpRequest, resourceContext);
        long start = System.currentTimeMillis();
        org.apache.http.HttpResponse result = this.httpClientHelper.execute((org.apache.http.HttpRequest)httpRequest, httpContext);
        long end = System.currentTimeMillis();
        this.filter.postRequest(httpRequest, result, httpContext, resourceContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug(httpRequest.getRequestLine().toString() + " -> " + result.getStatusLine().toString() + " (" + (end - start) + " ms)");
        }
        return result;
    }

    private org.apache.http.HttpResponse execute(GenericHttpRequest httpRequest, HttpRequest originalRequest, ResourceContext resourceContext) throws HttpErrorPage {
        RequestCookieStore cookieStore = new RequestCookieStore(this.cookieManager, resourceContext);
        HttpContext httpContext = this.httpClientHelper.createHttpContext(cookieStore);
        org.apache.http.HttpResponse httpResponse = this.executeSingleRequest(httpRequest, httpContext, resourceContext);
        while (this.authenticationHandler.needsNewRequest(httpResponse, resourceContext)) {
            HttpResponseUtils.release(httpResponse);
            httpResponse = this.executeSingleRequest(httpRequest, httpContext, resourceContext);
        }
        return httpResponse;
    }
}

