/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.esigate.ConfigurationException;
import org.esigate.Parameters;
import org.esigate.ResourceFactory;
import org.esigate.cache.CacheAdapter;
import org.esigate.cache.CacheConfigHelper;
import org.esigate.extension.Extension;
import org.esigate.http.HttpResourceFactory;
import org.esigate.http.RedirectStrategy;

public class ResourceFactoryCreator {
    static ResourceFactory create(Properties properties, HttpClient backend) {
        boolean useCache = Parameters.USE_CACHE.getValueBoolean(properties);
        HttpClient httpClient = useCache ? ResourceFactoryCreator.addCache(properties, backend) : backend;
        HttpResourceFactory result = new HttpResourceFactory(httpClient);
        return result;
    }

    public static ResourceFactory create(Properties properties) {
        DefaultHttpClient backend = ResourceFactoryCreator.createDefaultHttpClient(properties);
        return ResourceFactoryCreator.create(properties, (HttpClient)backend);
    }

    private static DefaultHttpClient createDefaultHttpClient(Properties properties) {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            SSLSocketFactory sslSocketFactory = new SSLSocketFactory(sslContext, SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
            Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory);
            schemeRegistry.register(https);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConfigurationException(e);
        }
        catch (KeyManagementException e) {
            throw new ConfigurationException(e);
        }
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(schemeRegistry);
        connectionManager.setMaxTotal(Parameters.MAX_CONNECTIONS_PER_HOST.getValueInt(properties));
        connectionManager.setDefaultMaxPerRoute(Parameters.MAX_CONNECTIONS_PER_HOST.getValueInt(properties));
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)Parameters.CONNECT_TIMEOUT.getValueInt(properties));
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)Parameters.SOCKET_TIMEOUT.getValueInt(properties));
        httpParams.setBooleanParameter("http.protocol.allow-circular-redirects", true);
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpParams);
        defaultHttpClient.setRedirectStrategy((org.apache.http.client.RedirectStrategy)new RedirectStrategy());
        String proxyHost = Parameters.PROXY_HOST.getValueString(properties);
        if (proxyHost != null) {
            int proxyPort = Parameters.PROXY_PORT.getValueInt(properties);
            String proxyUser = Parameters.PROXY_USER.getValueString(properties);
            if (proxyUser != null) {
                String proxyPassword = Parameters.PROXY_PASSWORD.getValueString(properties);
                defaultHttpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            }
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            defaultHttpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
        return defaultHttpClient;
    }

    private static HttpClient addCache(Properties properties, HttpClient backend) {
        Object cacheStorage;
        String cacheStorageClass = Parameters.CACHE_STORAGE.getValueString(properties);
        try {
            cacheStorage = Class.forName(cacheStorageClass).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not instantiate cacheStorageClass", e);
        }
        if (!(cacheStorage instanceof Extension) || !(cacheStorage instanceof HttpCacheStorage)) {
            throw new ConfigurationException("Cache storage class must implement Extension and HttpCacheStorage interfaces");
        }
        ((Extension)cacheStorage).init(properties);
        CacheConfig cacheConfig = CacheConfigHelper.createCacheConfig(properties);
        cacheConfig.setSharedCache(true);
        CacheAdapter cacheAdapter = new CacheAdapter();
        cacheAdapter.init(properties);
        HttpClient cachingHttpClient = cacheAdapter.wrapBackendHttpClient(backend);
        cachingHttpClient = new CachingHttpClient(cachingHttpClient, (HttpCacheStorage)cacheStorage, cacheConfig);
        cachingHttpClient = cacheAdapter.wrapCachingHttpClient(cachingHttpClient);
        return cachingHttpClient;
    }

    private ResourceFactoryCreator() {
    }
}

