/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.util.Properties;
import org.apache.http.impl.client.cache.CacheConfig;
import org.esigate.Parameters;

public class CacheConfigHelper {
    public static final CacheConfig createCacheConfig(Properties properties) {
        boolean heuristicCachingEnabled = Parameters.HEURISTIC_CACHING_ENABLED.getValueBoolean(properties);
        float heuristicCoefficient = Parameters.HEURISTIC_COEFFICIENT.getValueFloat(properties);
        long heuristicDefaultLifetimeSecs = Parameters.HEURISTIC_DEFAULT_LIFETIME_SECS.getValueLong(properties);
        int maxCacheEntries = Parameters.MAX_CACHE_ENTRIES.getValueInt(properties);
        int maxObjectSize = Parameters.MAX_OBJECT_SIZE.getValueInt(properties);
        int minAsynchronousWorkers = Parameters.MIN_ASYNCHRONOUS_WORKERS.getValueInt(properties);
        int maxAsynchronousWorkers = Parameters.MAX_ASYNCHRONOUS_WORKERS.getValueInt(properties);
        int asynchronousWorkerIdleLifetimeSecs = Parameters.ASYNCHRONOUS_WORKER_IDLE_LIFETIME_SECS.getValueInt(properties);
        int maxUpdateRetries = Parameters.MAX_UPDATE_RETRIES.getValueInt(properties);
        int revalidationQueueSize = Parameters.REVALIDATION_QUEUE_SIZE.getValueInt(properties);
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setHeuristicCachingEnabled(heuristicCachingEnabled);
        cacheConfig.setHeuristicCoefficient(heuristicCoefficient);
        cacheConfig.setHeuristicDefaultLifetime(heuristicDefaultLifetimeSecs);
        cacheConfig.setMaxCacheEntries(maxCacheEntries);
        if (maxObjectSize > 0) {
            cacheConfig.setMaxObjectSizeBytes(maxObjectSize);
        } else {
            cacheConfig.setMaxObjectSizeBytes(Integer.MAX_VALUE);
        }
        cacheConfig.setAsynchronousWorkersCore(minAsynchronousWorkers);
        cacheConfig.setAsynchronousWorkersMax(maxAsynchronousWorkers);
        cacheConfig.setAsynchronousWorkerIdleLifetimeSecs(asynchronousWorkerIdleLifetimeSecs);
        cacheConfig.setMaxUpdateRetries(maxUpdateRetries);
        cacheConfig.setRevalidationQueueSize(revalidationQueueSize);
        return cacheConfig;
    }
}

