/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.Serializable;
import org.esigate.api.Cookie;
import org.esigate.cookie.CustomCookieStore;

public class UserContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String user;
    private final CustomCookieStore cookieStore;

    public UserContext(CustomCookieStore cookieStore) {
        if (cookieStore == null) {
            throw new IllegalArgumentException("cookieStore implementation not set");
        }
        this.cookieStore = cookieStore;
    }

    public String getSessionId() {
        String result = null;
        for (Cookie cookie : this.cookieStore.getCookies()) {
            if (!"jsessionid".equalsIgnoreCase(cookie.getName())) continue;
            result = cookie.getValue();
            break;
        }
        return result;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("User=").append(this.user).append(" Cookies={\n");
        for (Cookie cookie : this.cookieStore.getCookies()) {
            result.append('\t');
            if (cookie.isSecure()) {
                result.append("https");
            } else {
                result.append("http");
            }
            result.append("://").append(cookie.getDomain()).append(cookie.getPath()).append('#').append(cookie.getName()).append('=').append(cookie.getValue()).append('\n');
        }
        return result.append('}').toString();
    }

    public CustomCookieStore getCookieStore() {
        return this.cookieStore;
    }

    public boolean isEmpty() {
        return this.user == null && this.cookieStore.getCookies().isEmpty();
    }
}

