/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.esigate.ConfigurationException;
import org.esigate.Driver;

public class DriverFactory {
    private static final String DEFAULT_INSTANCE = "default";
    private static final Map<String, Driver> INSTANCIES = new HashMap<String, Driver>();

    private DriverFactory() {
    }

    public static final void configure() {
        InputStream inputStream = Driver.class.getResourceAsStream("driver.properties");
        InputStream extInputStream = DriverFactory.class.getClassLoader().getResourceAsStream("driver-ext.properties");
        try {
            Properties merged = new Properties();
            if (inputStream != null) {
                Properties props = new Properties();
                props.load(inputStream);
                merged.putAll((Map<?, ?>)props);
            }
            if (extInputStream != null) {
                Properties extProps = new Properties();
                extProps.load(extInputStream);
                merged.putAll((Map<?, ?>)extProps);
            }
            DriverFactory.configure(merged);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error loading configuration", e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (extInputStream != null) {
                    extInputStream.close();
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("failed to close stream", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void configure(Properties props) {
        HashMap<String, Properties> driversProps = new HashMap<String, Properties>();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name;
            String prefix;
            String propertyName = (String)enumeration.nextElement();
            int idx = propertyName.lastIndexOf(46);
            if (idx < 0) {
                prefix = DEFAULT_INSTANCE;
                name = propertyName;
            } else {
                prefix = propertyName.substring(0, idx);
                name = propertyName.substring(idx + 1);
            }
            Properties driverProperties = (Properties)driversProps.get(prefix);
            if (driverProperties == null) {
                driverProperties = new Properties();
                driversProps.put(prefix, driverProperties);
            }
            driverProperties.put(name, props.getProperty(propertyName));
        }
        Map<String, Driver> map = INSTANCIES;
        synchronized (map) {
            INSTANCIES.clear();
            for (Map.Entry entry : driversProps.entrySet()) {
                DriverFactory.configure((String)entry.getKey(), (Properties)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure(String name, Properties props) {
        String effectiveName = name;
        if (effectiveName == null) {
            effectiveName = DEFAULT_INSTANCE;
        }
        Map<String, Driver> map = INSTANCIES;
        synchronized (map) {
            INSTANCIES.put(effectiveName, new Driver(name, props));
        }
    }

    public static final Driver getInstance() {
        return DriverFactory.getInstance(DEFAULT_INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Driver getInstance(String instanceName) {
        String effectiveInstanceName = instanceName;
        if (effectiveInstanceName == null) {
            effectiveInstanceName = DEFAULT_INSTANCE;
        }
        Map<String, Driver> map = INSTANCIES;
        synchronized (map) {
            if (INSTANCIES.isEmpty()) {
                throw new ConfigurationException("Driver has not been configured and driver.properties file was not found");
            }
            Driver instance = INSTANCIES.get(effectiveInstanceName);
            if (instance == null) {
                throw new ConfigurationException("No configuration properties found for factory : " + effectiveInstanceName);
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void put(String instanceName, Driver instance) {
        Map<String, Driver> map = INSTANCIES;
        synchronized (map) {
            INSTANCIES.put(instanceName, instance);
        }
    }

    static {
        DriverFactory.configure();
    }
}

