/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.esigate.http.BrowserCompatSpecFactory;
import org.esigate.http.RedirectStrategy;
import org.esigate.output.UnsupportedContentEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientResponse {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientResponse.class);
    private HttpResponse httpResponse;
    private HttpEntity httpEntity;
    private int statusCode;
    private String statusText;
    private InputStream content;
    private static final CookieSpecRegistry cookieSpecRegistry = new CookieSpecRegistry();

    public HttpClientResponse(HttpHost httpHost, HttpRequest httpRequest, HttpClient httpClient, CookieStore cookieStore) {
        BasicHttpContext httpContext = new BasicHttpContext();
        try {
            httpContext.setAttribute("http.cookiespec-registry", (Object)cookieSpecRegistry);
            httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
            this.httpResponse = httpClient.execute(httpHost, httpRequest, (HttpContext)httpContext);
            HttpRequest lastRequest = HttpClientResponse.getLastRequest(httpRequest, (HttpContext)httpContext);
            this.statusCode = this.httpResponse.getStatusLine().getStatusCode();
            this.statusText = this.httpResponse.getStatusLine().getReasonPhrase();
            this.httpEntity = this.httpResponse.getEntity();
            if (this.statusCode == 200 || this.statusCode == 304) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(lastRequest.getRequestLine() + " -> " + this.httpResponse.getStatusLine());
                }
            } else if (this.statusCode == 302 || this.statusCode == 301) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(lastRequest.getRequestLine() + " -> " + this.httpResponse.getStatusLine() + " Location: " + this.getHeader("Location"));
                }
            } else if (LOG.isWarnEnabled()) {
                LOG.warn(lastRequest.getRequestLine() + " -> " + this.httpResponse.getStatusLine());
            }
        }
        catch (HttpHostConnectException e) {
            this.statusCode = 502;
            this.statusText = "Connection refused";
            this.logError(httpRequest, (Exception)((Object)e));
        }
        catch (ConnectionPoolTimeoutException e) {
            this.statusCode = 504;
            this.statusText = "Connection pool timeout";
            this.logError(httpRequest, (Exception)((Object)e));
        }
        catch (ConnectTimeoutException e) {
            this.statusCode = 504;
            this.statusText = "Connect timeout";
            this.logError(httpRequest, (Exception)((Object)e));
        }
        catch (SocketTimeoutException e) {
            this.statusCode = 504;
            this.statusText = "Socket timeout";
            this.logError(httpRequest, e);
        }
        catch (IOException e) {
            this.statusCode = 500;
            this.statusText = "Error retrieving URL";
            this.logError(httpRequest, e);
        }
    }

    private static HttpRequest getLastRequest(HttpRequest httpRequest, HttpContext httpContext) {
        HttpRequest result = httpRequest;
        HttpRequest lastRedirectionRequest = RedirectStrategy.getLastRequest(httpContext);
        if (lastRedirectionRequest != null) {
            result = lastRedirectionRequest;
        }
        return result;
    }

    private void logError(HttpRequest request, Exception e) {
        LOG.error(request.getRequestLine() + " -> " + this.statusCode + " " + this.statusText, (Throwable)e);
    }

    HttpClientResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        this.statusCode = httpResponse.getStatusLine().getStatusCode();
        this.statusText = httpResponse.getStatusLine().getReasonPhrase();
        this.httpEntity = httpResponse.getEntity();
    }

    public void finish() {
        if (this.content != null) {
            try {
                this.content.close();
            }
            catch (IOException e) {
                LOG.warn("Could not close response stream properly", (Throwable)e);
            }
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getContentCharset() {
        if (this.httpEntity == null) {
            return null;
        }
        return EntityUtils.getContentCharSet((HttpEntity)this.httpEntity);
    }

    public InputStream openStream() throws IllegalStateException, IOException {
        if (this.httpEntity == null) {
            this.content = new ByteArrayInputStream(this.statusText.getBytes("ISO-8859-1"));
        } else {
            String contentEncoding = this.getHeader("Content-Encoding");
            if (contentEncoding != null) {
                if (!"gzip".equalsIgnoreCase(contentEncoding) && !"x-gzip".equalsIgnoreCase(contentEncoding)) {
                    throw new UnsupportedContentEncodingException("Content-encoding \"" + contentEncoding + "\" is not supported");
                }
                GzipDecompressingEntity compressed = new GzipDecompressingEntity(this.httpEntity);
                this.content = compressed.getContent();
            } else {
                this.content = this.httpEntity.getContent();
            }
        }
        return this.content;
    }

    public String getHeader(String name) {
        if (this.httpResponse == null) {
            return null;
        }
        Header header = this.httpResponse.getFirstHeader(name);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public Collection<String> getHeaderNames() {
        Header[] headers;
        HashSet<String> result = new HashSet<String>();
        if (this.httpResponse != null && (headers = this.httpResponse.getAllHeaders()) != null) {
            for (Header header : headers) {
                result.add(header.getName());
            }
        }
        return result;
    }

    public String[] getHeaders(String name) {
        Header[] headers;
        String[] result = null;
        if (this.httpResponse != null && (headers = this.httpResponse.getHeaders(name)) != null) {
            result = new String[headers.length];
            for (int i = 0; i < headers.length; ++i) {
                Header h = headers[i];
                result[i] = h.getValue();
            }
        }
        return result;
    }

    public String toString() {
        String result = this.statusCode + " " + this.statusText;
        if (this.statusCode == 301 || this.statusCode == 302) {
            result = result + " -> " + this.getHeader("Location");
        }
        return result;
    }

    static {
        cookieSpecRegistry.register("compatibility", (CookieSpecFactory)new BrowserCompatSpecFactory());
    }
}

