/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.params.ClientParamBean;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.esigate.DriverConfiguration;
import org.esigate.HttpErrorPage;
import org.esigate.http.HttpClientResponse;
import org.esigate.http.RewriteUtils;
import org.esigate.http.UnsupportedHttpMethodException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientRequest.class);
    private String uri;
    private final org.esigate.api.HttpRequest originalRequest;
    private final boolean proxy;
    private HttpRequest httpRequest;
    private HashMap<String, String> headers;
    private boolean preserveHost = false;
    private CookieStore cookieStore;
    private DriverConfiguration configuration;
    private static final String[] UNSAFE = new String[]{"{", "}", "|", "\\", "^", "~", "[", "]", "`"};
    private static final String[] ESCAPED = new String[]{"%7B", "%7D", "%7C", "%5C", "%5E", "%7E", "%5B", "%5D", "%60"};
    private static final Set<String> SIMPLE_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS", "TRACE", "DELETE")));
    private static final Set<String> ENTITY_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("POST", "PUT", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK")));

    public HttpClientRequest(String uri, org.esigate.api.HttpRequest originalRequest, boolean proxy, boolean preserveHost) {
        this.uri = HttpClientRequest.escapeUnsafeCharacters(uri);
        this.originalRequest = originalRequest;
        this.proxy = proxy;
        this.preserveHost = preserveHost;
    }

    private static String escapeUnsafeCharacters(String url) {
        String result = url;
        for (int i = 0; i < UNSAFE.length; ++i) {
            result = result.replaceAll(Pattern.quote(UNSAFE[i]), ESCAPED[i]);
        }
        return result;
    }

    public HttpClientResponse execute(HttpClient httpClient) throws IOException, HttpErrorPage {
        HttpHost uriHost;
        try {
            uriHost = URIUtils.extractHost((URI)new URI(this.uri));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpHost targetHost = uriHost;
        HttpHost virtualHost = null;
        HttpRoute route = null;
        if (this.preserveHost) {
            int originalport = -1;
            if (this.originalRequest.getServerPort() != 80 && this.originalRequest.getServerPort() != 443) {
                originalport = this.originalRequest.getServerPort();
            }
            targetHost = virtualHost = new HttpHost(this.originalRequest.getServerName(), originalport, this.originalRequest.getScheme());
            HttpHost proxyHost = (HttpHost)httpClient.getParams().getParameter("http.route.default-proxy");
            route = proxyHost == null ? new HttpRoute(uriHost) : new HttpRoute(uriHost, null, proxyHost, false);
            try {
                this.uri = URIUtils.rewriteURI((URI)new URI(this.uri), (HttpHost)targetHost).toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        this.buildHttpMethod();
        if (virtualHost != null) {
            ClientParamBean clientParamBean = new ClientParamBean(this.httpRequest.getParams());
            clientParamBean.setVirtualHost(virtualHost);
            this.httpRequest.getParams().setParameter("http.route.forced-route", route);
        }
        long start = System.currentTimeMillis();
        HttpClientResponse result = new HttpClientResponse(targetHost, this.httpRequest, httpClient, this.cookieStore);
        long end = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.toString() + " -> " + result.toString() + " (" + (end - start) + " ms)");
        }
        return result;
    }

    private static void copyEntity(org.esigate.api.HttpRequest src, HttpEntityEnclosingRequest dest) throws IOException {
        long contentLength = src.getHeader("Content-Length") != null ? Long.parseLong(src.getHeader("Content-Length")) : -1L;
        InputStreamEntity inputStreamEntity = new InputStreamEntity(src.getInputStream(), contentLength);
        if (src.getContentType() != null) {
            inputStreamEntity.setContentType(src.getContentType());
        }
        if (src.getHeader("Content-Encoding") != null) {
            inputStreamEntity.setContentEncoding(src.getHeader("Content-Encoding"));
        }
        dest.setEntity((HttpEntity)inputStreamEntity);
    }

    private static HttpRequest createRequestObject(String uri, String method, org.esigate.api.HttpRequest originalRequest) throws IOException {
        if (SIMPLE_METHODS.contains(method)) {
            return new BasicHttpRequest(method, uri);
        }
        if (ENTITY_METHODS.contains(method)) {
            BasicHttpEntityEnclosingRequest result = new BasicHttpEntityEnclosingRequest(method, uri);
            HttpClientRequest.copyEntity(originalRequest, (HttpEntityEnclosingRequest)result);
            return result;
        }
        throw new UnsupportedHttpMethodException(method + " " + uri);
    }

    private void buildHttpMethod() throws IOException, HttpErrorPage {
        String method = this.proxy ? this.originalRequest.getMethod().toUpperCase() : "GET";
        this.httpRequest = HttpClientRequest.createRequestObject(this.uri, method, this.originalRequest);
        this.httpRequest.getParams().setParameter("http.protocol.handle-redirects", (Object)(!this.proxy ? 1 : 0));
        this.httpRequest.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        Integer maxWait = this.originalRequest.getFetchMaxWait();
        if (maxWait != null) {
            HttpConnectionParams.setSoTimeout((HttpParams)this.httpRequest.getParams(), (int)maxWait);
        }
        for (String string : this.originalRequest.getHeaderNames()) {
            String value;
            if ("User-Agent".equalsIgnoreCase(string) && this.configuration.isForwardedRequestHeader("User-Agent")) {
                this.httpRequest.getParams().setParameter("http.useragent", (Object)this.originalRequest.getHeader(string));
                continue;
            }
            if ("Expect".equalsIgnoreCase(string)) {
                throw new HttpErrorPage(417, "Expection failed", "This server does not support 'Expect' HTTP header.");
            }
            if ("Referer".equalsIgnoreCase(string)) {
                value = this.originalRequest.getHeader(string);
                String originalUrlWithQueryString = this.originalRequest.getRequestURL();
                if (this.originalRequest.getQueryString() != null) {
                    originalUrlWithQueryString = originalUrlWithQueryString + "?" + this.originalRequest.getQueryString();
                }
                value = RewriteUtils.translateUrl(value, originalUrlWithQueryString, this.uri);
                this.httpRequest.addHeader(string, value);
                continue;
            }
            if (!this.configuration.isForwardedRequestHeader(string) || (value = this.originalRequest.getHeader(string)) == null) continue;
            this.httpRequest.addHeader(string, value);
        }
        if (this.originalRequest.getHeader("X-Forwarded-For") == null && (this.configuration == null || this.configuration.isForwardedRequestHeader("X-Forwarded-For")) && this.originalRequest.getRemoteAddr() != null) {
            this.httpRequest.addHeader("X-Forwarded-For", this.originalRequest.getRemoteAddr());
        }
        if (this.headers != null) {
            for (Map.Entry entry : this.headers.entrySet()) {
                this.httpRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(name, value);
    }

    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.headers);
    }

    public String toString() {
        return this.httpRequest.getRequestLine().toString();
    }

    public boolean isPreserveHost() {
        return this.preserveHost;
    }

    public void setPreserveHost(boolean preserveHost) {
        this.preserveHost = preserveHost;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void setConfiguration(DriverConfiguration configuration) {
        this.configuration = configuration;
    }
}

