/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.esigate.ResponseOutputStream;
import org.esigate.api.HttpResponse;
import org.esigate.output.Output;

class ResponseOutput
extends Output {
    private final HttpResponse response;
    private OutputStream outputStream;

    public ResponseOutput(HttpResponse response) {
        this.response = response;
    }

    public void open() throws IOException {
        this.response.setStatus(this.getStatusCode());
        this.copyHeaders();
        this.outputStream = new ResponseOutputStream(this.response.getOutputStream());
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private void copyHeaders() {
        for (Map.Entry<String, Set<String>> entry : this.getHeaders().entrySet()) {
            Set<String> values = entry.getValue();
            for (String value : values) {
                this.response.addHeader(entry.getKey(), value);
            }
        }
    }

    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

