/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.esigate.Driver;
import org.esigate.UserContext;
import org.esigate.api.HttpRequest;
import org.esigate.api.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceContext {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceContext.class);
    private final Driver driver;
    private final String baseURL;
    private final String relUrl;
    private final HttpRequest originalRequest;
    private final HttpResponse originalResponse;
    private final Map<String, String> parameters;
    private boolean proxy = false;
    private boolean preserveHost = false;
    private URL baseURLasURL = null;

    public Driver getDriver() {
        return this.driver;
    }

    public boolean isPreserveHost() {
        return this.preserveHost;
    }

    public void setPreserveHost(boolean preserveHost) {
        this.preserveHost = preserveHost;
    }

    public void setProxy(boolean proxyMode) {
        this.proxy = proxyMode;
    }

    public ResourceContext(Driver driver, String relUrl, Map<String, String> parameters, HttpRequest originalRequest, HttpResponse originalResponse) {
        this.driver = driver;
        String baseURLLocal = null;
        if (null != driver && null != driver.getConfiguration() && null != driver.getConfiguration().getBaseUrlRetrieveStrategy()) {
            baseURLLocal = driver.getConfiguration().getBaseUrlRetrieveStrategy().getBaseURL(originalRequest, originalResponse);
        }
        this.baseURL = baseURLLocal;
        this.relUrl = relUrl;
        this.parameters = parameters != null ? parameters : new HashMap<String, String>();
        this.originalRequest = originalRequest;
        this.originalResponse = originalResponse;
    }

    public String getRelUrl() {
        return this.relUrl;
    }

    public HttpRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public UserContext getUserContext() {
        return this.driver.getUserContext(this.originalRequest);
    }

    public HttpResponse getOriginalResponse() {
        return this.originalResponse;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public URL getBaseURLasURL() {
        if (null == this.baseURLasURL && null != this.baseURL) {
            try {
                this.baseURLasURL = new URL(this.baseURL);
            }
            catch (MalformedURLException e) {
                LOG.error("Base URL is not valid", (Throwable)e);
            }
        }
        return this.baseURLasURL;
    }
}

