/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.esigate.output.OutputException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Output {
    private String charsetName;
    private int statusCode;
    private String statusMessage;
    private final Map<String, Set<String>> headers = Collections.synchronizedMap(new HashMap());

    public final void setStatus(int code, String message) {
        this.statusCode = code;
        this.statusMessage = message;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public final String getStatusMessage() {
        return this.statusMessage;
    }

    public final void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    protected final Map<String, Set<String>> getHeaders() {
        return this.headers;
    }

    public final String getHeader(String key) {
        String result = null;
        for (Map.Entry<String, Set<String>> entry : this.headers.entrySet()) {
            if (!key.equalsIgnoreCase(entry.getKey()) || entry.getValue().isEmpty()) continue;
            result = entry.getValue().iterator().next();
            break;
        }
        return result;
    }

    public final void setHeader(String key, String value) {
        String keyToRemove = null;
        for (String header : this.headers.keySet()) {
            if (!key.equalsIgnoreCase(header)) continue;
            keyToRemove = header;
            break;
        }
        if (keyToRemove != null) {
            this.headers.remove(keyToRemove);
        }
        this.addHeader(key, value);
    }

    public final void addHeader(String name, String value) {
        Set<String> values = null;
        for (Map.Entry<String, Set<String>> entry : this.headers.entrySet()) {
            if (!name.equalsIgnoreCase(entry.getKey())) continue;
            values = entry.getValue();
            break;
        }
        if (values == null) {
            values = Collections.synchronizedSortedSet(new TreeSet());
            this.headers.put(name, values);
        }
        values.add(value);
    }

    public final void copyHeaders(Output dest) {
        dest.headers.putAll(this.headers);
    }

    public final String getCharsetName() {
        return this.charsetName;
    }

    public final void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public abstract void open();

    public abstract OutputStream getOutputStream();

    public abstract void close();

    public final void write(String string) {
        try {
            if (this.charsetName != null) {
                this.getOutputStream().write(string.getBytes(this.charsetName));
            } else {
                this.getOutputStream().write(string.getBytes("ISO-8859-1"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new OutputException(e);
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
    }
}

