/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.esigate.ResourceContext;
import org.esigate.UserContext;

public class RewriteUtils {
    private RewriteUtils() {
    }

    public static final String removeSessionId(String sessionId, String page) {
        String regexp = ";?jsessionid=" + Pattern.quote(sessionId);
        return page.replaceAll(regexp, "");
    }

    public static final String getSessionId(ResourceContext resourceContext) {
        UserContext userContext = resourceContext.getUserContext();
        String jsessionid = userContext != null ? userContext.getSessionId() : null;
        return jsessionid;
    }

    public static final String translateUrl(String sourceUrl, String sourceContext, String targetContext) throws MalformedURLException {
        String commonSuffix = StringUtils.reverse((String)StringUtils.getCommonPrefix((String[])new String[]{StringUtils.reverse((String)sourceContext), StringUtils.reverse((String)targetContext)}));
        String sourcePrefix = StringUtils.removeEnd((String)sourceContext, (String)commonSuffix);
        String targetPrefix = StringUtils.removeEnd((String)targetContext, (String)commonSuffix);
        String absoluteSourceUrl = new URL(new URL(sourceContext), sourceUrl).toString();
        if (absoluteSourceUrl.startsWith(sourcePrefix)) {
            return targetPrefix + StringUtils.removeStart((String)absoluteSourceUrl, (String)sourcePrefix);
        }
        return absoluteSourceUrl;
    }
}

