/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.util.Collection;
import java.util.Properties;
import org.apache.http.client.CookieStore;
import org.esigate.ConfigurationException;
import org.esigate.ResourceContext;
import org.esigate.extension.ExtensionFactory;
import org.esigate.filter.Filter;
import org.esigate.http.CookieAdapter;
import org.esigate.http.HttpClientRequest;
import org.esigate.http.HttpClientResponse;
import org.esigate.http.RequestCookieStore;
import org.esigate.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieForwardingFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionFactory.class);
    private Collection<String> discardCookies;
    private Collection<String> forwardCookies;

    Collection<String> getForwardCookies() {
        return this.forwardCookies;
    }

    @Override
    public void init(Properties properties) {
        this.forwardCookies = PropertiesUtil.getPropertyValueAsList(properties, "forwardCookies");
        this.discardCookies = PropertiesUtil.getPropertyValueAsList(properties, "discardCookies");
        if (this.forwardCookies.contains("*") && this.forwardCookies.size() > 1) {
            throw new ConfigurationException("forwardCookies must be a list of cookie names OR *");
        }
        if (this.discardCookies.contains("*") && this.discardCookies.size() > 1) {
            throw new ConfigurationException("discardCookies must be a list of cookie names OR *");
        }
        if (this.forwardCookies.contains("*") && this.discardCookies.contains("*")) {
            throw new ConfigurationException("cannot use * for forwardCookies AND discardCookies at the same time");
        }
    }

    @Override
    public void postRequest(HttpClientResponse response, ResourceContext context) {
    }

    @Override
    public void preRequest(HttpClientRequest request, ResourceContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("preRequest");
        }
        CookieStore cookieStore = CookieAdapter.convertCookieStore(context.getUserContext().getCookieStore());
        RequestCookieStore wrappedCookieStore = new RequestCookieStore(this.discardCookies, this.forwardCookies, cookieStore, request, context);
        request.setCookieStore(wrappedCookieStore);
    }

    @Override
    public boolean needUserContext() {
        return true;
    }
}

