/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.esigate.file.FileUtils;
import org.esigate.file.HeadersFile;
import org.esigate.output.Output;
import org.esigate.output.OutputException;

public class FileOutput
extends Output {
    private final File file;
    private final File headerFile;
    private FileOutputStream fileOutputStream;

    public FileOutput(File dataFile, File headersFile) {
        this.file = dataFile;
        this.headerFile = headersFile;
    }

    public void open() {
        try {
            if (!this.file.exists()) {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            this.fileOutputStream = new FileOutputStream(this.file);
        }
        catch (IOException e) {
            throw new OutputException("Could not create file: " + this.file.toURI(), e);
        }
    }

    public OutputStream getOutputStream() {
        return this.fileOutputStream;
    }

    public void close() {
        try {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.close();
            }
        }
        catch (IOException e) {
            throw new OutputException("Could not close file: " + this.file.toURI(), e);
        }
        finally {
            this.fileOutputStream = null;
        }
        try {
            FileUtils.storeHeaders(this.headerFile, new HeadersFile(this.getHeaders(), this.getStatusCode(), this.getStatusMessage()));
        }
        catch (IOException e) {
            throw new OutputException("Could not write to file: " + this.headerFile.toURI(), e);
        }
    }

    public void delete() {
        this.file.delete();
        this.headerFile.delete();
    }
}

