/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.aggregator;

import java.io.IOException;
import org.esigate.Driver;
import org.esigate.HttpErrorPage;
import org.esigate.aggregator.Adapter;
import org.esigate.aggregator.AggregateRenderer;
import org.esigate.aggregator.ElementAttributes;
import org.esigate.aggregator.ElementAttributesFactory;
import org.esigate.parser.Element;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContext;
import org.esigate.tags.BlockRenderer;

class IncludeBlockElement
implements Element {
    public static final ElementType TYPE = new ElementType(){

        public boolean isStartTag(String tag) {
            return tag.startsWith("<!--$includeblock$");
        }

        public boolean isEndTag(String tag) {
            return tag.startsWith("<!--$endincludeblock$");
        }

        public Element newInstance() {
            return new IncludeBlockElement();
        }
    };

    IncludeBlockElement() {
    }

    public boolean onError(Exception e, ParserContext ctx) {
        return false;
    }

    public void onTagEnd(String tag, ParserContext ctx) {
    }

    public void onTagStart(String tag, ParserContext ctx) throws IOException, HttpErrorPage {
        ElementAttributes tagAttributes = ElementAttributesFactory.createElementAttributes(tag);
        Driver driver = tagAttributes.getDriver();
        String page = tagAttributes.getPage();
        String name = tagAttributes.getName();
        driver.render(page, new Adapter(ctx.getCurrent()), ctx.getResourceContext(), new BlockRenderer(name, page), new AggregateRenderer());
    }

    public boolean isClosed() {
        return false;
    }

    public void characters(CharSequence csq, int start, int end) throws IOException {
    }
}

