/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.tags;

import java.io.IOException;
import org.esigate.HttpErrorPage;
import org.esigate.aggregator.AggregationSyntaxException;
import org.esigate.parser.Element;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContext;
import org.esigate.tags.TemplateRenderer;

class TemplateElement
implements Element {
    private TemplateRenderer templateRenderer;
    private boolean nameMatches;
    public static final ElementType TYPE = new ElementType(){

        public boolean isStartTag(String tag) {
            return tag.startsWith("<!--$begintemplate$");
        }

        public boolean isEndTag(String tag) {
            return tag.startsWith("<!--$endtemplate$");
        }

        public Element newInstance() {
            return new TemplateElement();
        }
    };

    TemplateElement() {
    }

    public boolean onError(Exception e, ParserContext ctx) {
        return false;
    }

    public void onTagEnd(String tag, ParserContext ctx) throws IOException, HttpErrorPage {
        if (this.nameMatches) {
            this.templateRenderer.setWrite(false);
        }
    }

    public void onTagStart(String tag, ParserContext ctx) throws IOException, HttpErrorPage {
        String[] parameters = tag.split("\\$");
        if (parameters.length != 4) {
            throw new AggregationSyntaxException("Invalid syntax: " + tag);
        }
        String name = parameters[2];
        this.templateRenderer = ctx.findAncestor(TemplateRenderer.class);
        this.nameMatches = name.equals(this.templateRenderer.getName());
        if (this.nameMatches) {
            this.templateRenderer.setWrite(true);
        }
    }

    public void characters(CharSequence csq, int start, int end) throws IOException {
        if (this.nameMatches) {
            this.templateRenderer.append(csq, start, end);
        }
    }

    public boolean isClosed() {
        return false;
    }

    public boolean isNameMatches() {
        return this.nameMatches;
    }
}

