/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.output;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.esigate.output.Output;
import org.esigate.output.OutputException;

public class MultipleOutput
extends Output {
    private final ArrayList<Output> outputs = new ArrayList();
    private OutputStream output;

    public void addOutput(Output output) {
        this.outputs.add(output);
    }

    public void open() {
        for (Output output : this.outputs) {
            this.copyHeaders(output);
            output.setStatus(this.getStatusCode(), this.getStatusMessage());
            output.setCharsetName(this.getCharsetName());
            output.open();
        }
        this.output = ChainedOutputStream.createChain(this.outputs);
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public void close() {
        try {
            if (this.output != null) {
                this.output.close();
            }
            for (Output output : this.outputs) {
                output.close();
            }
        }
        catch (IOException e) {
            throw new OutputException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ChainedOutputStream
    extends FilterOutputStream {
        private final OutputStream next;

        public ChainedOutputStream(OutputStream dest, OutputStream next) {
            super(dest);
            this.next = next;
        }

        @Override
        public void write(int b) throws IOException {
            byte[] buf = new byte[]{(byte)b};
            this.write(buf, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.next.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.next.close();
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.next.flush();
        }

        public static OutputStream createChain(List<Output> outputs) {
            OutputStream current = null;
            OutputStream previous = null;
            for (Output output : outputs) {
                current = previous == null ? output.getOutputStream() : new ChainedOutputStream(output.getOutputStream(), previous);
                previous = current;
            }
            return current;
        }
    }
}

