/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.parser;

import java.io.IOException;
import java.util.Stack;
import org.esigate.HttpErrorPage;
import org.esigate.ResourceContext;
import org.esigate.parser.Element;
import org.esigate.parser.ElementType;
import org.esigate.parser.ParserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParserContextImpl
implements ParserContext {
    private final RootAdapter root;
    private final ResourceContext resourceContext;
    private final Stack<Pair> stack = new Stack();

    ParserContextImpl(Appendable root, ResourceContext resourceContext) {
        this.root = new RootAdapter(root);
        this.resourceContext = resourceContext;
    }

    @Override
    public <T> T findAncestor(Class<T> type) {
        T result = null;
        for (int i = this.stack.size() - 1; i > -1; --i) {
            Element currentElement = ((Pair)this.stack.elementAt(i)).element;
            if (!type.isInstance(currentElement)) continue;
            result = type.cast(currentElement);
            break;
        }
        if (result == null && type.isInstance(this.root.root)) {
            result = type.cast(this.root.root);
        }
        return result;
    }

    @Override
    public boolean reportError(Exception e) {
        boolean result = false;
        for (int i = this.stack.size() - 1; i > -1; --i) {
            Element element = ((Pair)this.stack.elementAt(i)).element;
            if (!element.onError(e, this)) continue;
            result = true;
            break;
        }
        return result;
    }

    void startElement(ElementType type, Element element, String tag) throws IOException, HttpErrorPage {
        element.onTagStart(tag, this);
        this.stack.push(new Pair(type, element));
    }

    void endElement(String tag) throws IOException, HttpErrorPage {
        Element element = this.stack.pop().element;
        element.onTagEnd(tag, this);
    }

    boolean isCurrentTagEnd(String tag) {
        return !this.stack.isEmpty() && this.stack.peek().type.isEndTag(tag);
    }

    void characters(CharSequence cs) throws IOException {
        this.characters(cs, 0, cs.length());
    }

    void characters(CharSequence csq, int start, int end) throws IOException {
        this.getCurrent().characters(csq, start, end);
    }

    @Override
    public Element getCurrent() {
        return !this.stack.isEmpty() ? this.stack.peek().element : this.root;
    }

    @Override
    public ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    private static class RootAdapter
    implements Element {
        private final Appendable root;

        public RootAdapter(Appendable root) {
            this.root = root;
        }

        public void onTagStart(String tag, ParserContext ctx) {
        }

        public void onTagEnd(String tag, ParserContext ctx) {
        }

        public boolean onError(Exception e, ParserContext ctx) {
            return false;
        }

        public void characters(CharSequence csq, int start, int end) throws IOException {
            this.root.append(csq, start, end);
        }

        public boolean isClosed() {
            return false;
        }
    }

    private static class Pair {
        private final ElementType type;
        private final Element element;

        public Pair(ElementType type, Element element) {
            this.type = type;
            this.element = element;
        }
    }
}

