/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpClient;
import org.esigate.Driver;
import org.esigate.ResourceContext;
import org.esigate.UserContext;
import org.esigate.api.HttpRequest;
import org.esigate.authentication.AuthenticationHandler;
import org.esigate.filter.Filter;
import org.esigate.http.CookieAdapter;
import org.esigate.http.HttpClientRequest;
import org.esigate.http.HttpClientResponse;
import org.esigate.http.RewriteUtils;
import org.esigate.output.Output;
import org.esigate.resource.Resource;
import org.esigate.resource.ResourceUtils;
import org.esigate.util.Rfc2616;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResource
extends Resource {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResource.class);
    private HttpClientResponse httpClientResponse;
    private final ResourceContext target;
    private final String url;

    public HttpResource(HttpClient httpClient, ResourceContext resourceContext) throws IOException {
        this.target = resourceContext;
        this.url = ResourceUtils.getHttpUrlWithQueryString(resourceContext);
        Driver driver = resourceContext.getDriver();
        HttpRequest originalRequest = resourceContext.getOriginalRequest();
        UserContext userContext = resourceContext.getUserContext();
        boolean proxy = resourceContext.isProxy();
        boolean preserveHost = resourceContext.isPreserveHost();
        HttpClientRequest httpClientRequest = new HttpClientRequest(this.url, originalRequest, proxy, preserveHost);
        httpClientRequest.setCookieStore(CookieAdapter.convertCookieStore(userContext.getCookieStore()));
        if (resourceContext.getValidators() != null) {
            for (Map.Entry<String, String> header : resourceContext.getValidators().entrySet()) {
                LOG.debug("Adding validator: " + header.getKey() + ": " + header.getValue());
                httpClientRequest.addHeader(header.getKey(), header.getValue());
            }
        }
        AuthenticationHandler authenticationHandler = driver.getAuthenticationHandler();
        authenticationHandler.preRequest(httpClientRequest, resourceContext);
        Filter filter = driver.getFilter();
        filter.preRequest(httpClientRequest, resourceContext);
        this.httpClientResponse = httpClientRequest.execute(httpClient);
        resourceContext.getDriver().saveUserContext(resourceContext.getOriginalRequest());
        while (authenticationHandler.needsNewRequest(this.httpClientResponse, resourceContext)) {
            this.httpClientResponse.finish();
            httpClientRequest = new HttpClientRequest(this.url, originalRequest, proxy, preserveHost);
            authenticationHandler.preRequest(httpClientRequest, resourceContext);
            filter.preRequest(httpClientRequest, resourceContext);
            this.httpClientResponse = httpClientRequest.execute(httpClient);
            resourceContext.getDriver().saveUserContext(resourceContext.getOriginalRequest());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Output output) throws IOException {
        String charset;
        output.setStatus(this.httpClientResponse.getStatusCode(), this.httpClientResponse.getStatusText());
        Rfc2616.copyHeaders(this.target.getDriver().getConfiguration(), this, output);
        this.target.getDriver().getFilter().postRequest(this.httpClientResponse, this.target);
        String location = this.httpClientResponse.getHeader("Location");
        if (location != null) {
            location = this.rewriteLocation(location);
            location = this.removeSessionId(location);
            output.setHeader("Location", location);
        }
        if ((charset = this.httpClientResponse.getContentCharset()) != null) {
            output.setCharsetName(charset);
        }
        try {
            output.open();
            InputStream inputStream = this.httpClientResponse.openStream();
            if (inputStream != null) {
                this.removeSessionId(inputStream, output);
            }
        }
        finally {
            output.close();
        }
    }

    private String rewriteLocation(String location) throws MalformedURLException {
        location = new URL(new URL(this.url), location).toString();
        HttpRequest request = this.target.getOriginalRequest();
        String originalBase = request.getRequestURL();
        int pos = originalBase.lastIndexOf(this.target.getRelUrl());
        String driverBaseUrl = this.target.getDriver().getConfiguration().getBaseURL();
        if (pos >= 0 && (originalBase = originalBase.substring(0, pos)).charAt(originalBase.length() - 1) != '/' && driverBaseUrl.charAt(driverBaseUrl.length() - 1) == '/') {
            originalBase = originalBase + "/";
        }
        return location.replaceFirst(driverBaseUrl, originalBase);
    }

    private void removeSessionId(InputStream inputStream, Output output) throws IOException {
        String jsessionid = RewriteUtils.getSessionId(this.target);
        boolean textContentType = ResourceUtils.isTextContentType(this.httpClientResponse.getHeader("Content-Type"), this.target.getDriver().getConfiguration().getParsableContentTypes());
        if (jsessionid == null || !textContentType) {
            IOUtils.copy((InputStream)inputStream, (OutputStream)output.getOutputStream());
        } else {
            String charset = this.httpClientResponse.getContentCharset();
            if (charset == null) {
                charset = "ISO-8859-1";
            }
            String content = IOUtils.toString((InputStream)inputStream, (String)charset);
            content = this.removeSessionId(jsessionid, content);
            if (output.getHeader("Content-Length") != null) {
                output.setHeader("Content-Length", Integer.toString(content.length()));
            }
            OutputStream outputStream = output.getOutputStream();
            IOUtils.write((String)content, (OutputStream)outputStream, (String)charset);
        }
        inputStream.close();
    }

    private String removeSessionId(String src) {
        String sessionId = RewriteUtils.getSessionId(this.target);
        return this.removeSessionId(sessionId, src);
    }

    private String removeSessionId(String sessionId, String src) {
        if (sessionId == null) {
            return src;
        }
        return RewriteUtils.removeSessionId(sessionId, src);
    }

    @Override
    public void release() {
        this.httpClientResponse.finish();
    }

    @Override
    public int getStatusCode() {
        return this.httpClientResponse.getStatusCode();
    }

    @Override
    public String getStatusMessage() {
        return this.httpClientResponse.getStatusText();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.target.getOriginalRequest().getMethod());
        result.append(" ");
        result.append(ResourceUtils.getHttpUrlWithQueryString(this.target));
        result.append("\n");
        result.append(this.target.getUserContext().toString());
        return result.toString();
    }

    @Override
    public String getHeader(String name) {
        return this.httpClientResponse.getHeader(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return Arrays.asList(this.httpClientResponse.getHeaders(name));
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.httpClientResponse.getHeaderNames();
    }
}

