/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.esigate.file.HeadersFile;

class FileUtils {
    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HeadersFile loadHeaders(File src) throws IOException {
        LineNumberReader in = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(src), "UTF-8"));
        try {
            HeadersFile result = new HeadersFile();
            String line = null;
            while ((line = in.readLine()) != null) {
                int idx;
                if (line.startsWith("#") || (idx = line.indexOf(61)) == -1) continue;
                String key = line.substring(0, idx).trim();
                String value = line.substring(idx + 1);
                if (StringUtils.isNumeric((CharSequence)key)) {
                    result.setStatusCode(Integer.parseInt(key));
                    result.setStatusMessage(value);
                    continue;
                }
                result.addHeader(key, value);
            }
            HeadersFile headersFile = result;
            return headersFile;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeHeaders(File dest, HeadersFile headers) throws IOException {
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dest), "UTF-8"));
        try {
            out.println("#Headers");
            out.println("#" + new Date().toString());
            for (Map.Entry<String, Set<String>> entry : headers.getHeadersMap().entrySet()) {
                for (String value : entry.getValue()) {
                    out.println(entry.getKey() + "=" + value);
                }
            }
            out.println(Integer.toString(headers.getStatusCode()) + "=" + headers.getStatusMessage());
        }
        finally {
            out.close();
        }
    }
}

