/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.esigate.api.HttpRequest;
import org.esigate.cache.BaseCachedResource;
import org.esigate.cache.CachedResponseSummary;
import org.esigate.output.Output;
import org.esigate.util.Rfc2616;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedResponse
extends BaseCachedResource {
    private static final long serialVersionUID = 8125407854908774093L;
    private final byte[] byteArray;
    private final String charset;
    private final Date localDate = new Date();
    private Map<String, String> requestHeaders;

    public CachedResponse(byte[] byteArray, String charset, Map<String, Set<String>> headers, int statusCode, String statusMessage) {
        super(headers, statusCode, statusMessage);
        this.byteArray = byteArray;
        this.charset = charset;
    }

    @Override
    public boolean hasResponseBody() {
        return this.byteArray != null;
    }

    public byte[] getByteArray() {
        return this.byteArray;
    }

    public CachedResponse() {
        super(null, 0, null);
        this.byteArray = null;
        this.charset = null;
        this.requestHeaders = null;
    }

    @Override
    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Output output) throws IOException {
        output.setStatus(this.statusCode, this.statusMessage);
        try {
            output.setCharsetName(this.charset);
            for (Map.Entry entry : this.headers.entrySet()) {
                for (String value : (Set)entry.getValue()) {
                    output.addHeader((String)entry.getKey(), value);
                }
            }
            output.open();
            output.getOutputStream().write(this.byteArray, 0, this.byteArray.length);
        }
        finally {
            output.close();
        }
    }

    @Override
    public Date getLocalDate() {
        return this.localDate;
    }

    public String toString() {
        return this.statusCode + " " + this.statusMessage + " age=" + Rfc2616.getAge(this) + " stale=" + Rfc2616.isStale(this) + " hasBody=" + this.hasResponseBody();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.byteArray);
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.localDate == null ? 0 : this.localDate.hashCode());
        result = 31 * result + (this.requestHeaders == null ? 0 : this.requestHeaders.hashCode());
        result = 31 * result + this.statusCode;
        result = 31 * result + (this.statusMessage == null ? 0 : this.statusMessage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachedResponse other = (CachedResponse)obj;
        if (!Arrays.equals(this.byteArray, other.byteArray)) {
            return false;
        }
        if (this.charset == null ? other.charset != null : !this.charset.equals(other.charset)) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.localDate == null ? other.localDate != null : !this.localDate.equals(other.localDate)) {
            return false;
        }
        if (this.requestHeaders == null ? other.requestHeaders != null : !this.requestHeaders.equals(other.requestHeaders)) {
            return false;
        }
        if (this.statusCode != other.statusCode) {
            return false;
        }
        return !(this.statusMessage == null ? other.statusMessage != null : !this.statusMessage.equals(other.statusMessage));
    }

    @Override
    public String getRequestHeader(String key) {
        if (this.requestHeaders != null) {
            for (String name : this.requestHeaders.keySet()) {
                if (!key.equalsIgnoreCase(name)) continue;
                return this.requestHeaders.get(name);
            }
        }
        return null;
    }

    public void setRequestHeader(String name, String value) {
        if (this.requestHeaders == null) {
            this.requestHeaders = new HashMap<String, String>();
        }
        this.requestHeaders.put(name, value);
    }

    public void setRequestHeadersFromRequest(HttpRequest request) {
        Collection<String> e = request.getHeaderNames();
        if (e != null && !e.isEmpty()) {
            HashMap<String, String> headers = new HashMap<String, String>();
            for (String name : e) {
                headers.put(name, request.getHeader(name));
            }
            this.requestHeaders = headers;
        } else {
            this.requestHeaders = null;
        }
    }

    public CachedResponseSummary getSummary(String key) {
        CachedResponseSummary s = new CachedResponseSummary(key, new HashMap<String, Set<String>>(this.headers), this.statusCode, this.statusMessage);
        s.setResponseBody(this.hasResponseBody());
        s.setLocalDate(this.localDate);
        HashMap<String, String> requestHeaders2 = new HashMap<String, String>();
        if (this.requestHeaders != null) {
            requestHeaders2.putAll(this.requestHeaders);
        }
        s.setRequestHeaders(requestHeaders2);
        return s;
    }
}

