/*
 * Decompiled with CFR 0.152.
 */
package org.esigate;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.esigate.ConfigurationException;
import org.esigate.authentication.RemoteUserAuthenticationHandler;
import org.esigate.cache.CacheStorage;
import org.esigate.cache.DefaultCacheStorage;
import org.esigate.cookie.SerializableBasicCookieStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverConfiguration {
    private final String instanceName;
    private final String baseURL;
    private String uriEncoding = "ISO-8859-1";
    private boolean fixResources = false;
    private String visibleBaseURL = null;
    private int fixMode = 1;
    private int maxConnectionsPerHost = 20;
    private int timeout = 1000;
    private boolean useCache = true;
    private int cacheRefreshDelay = 0;
    private int cacheMaxFileSize = 0;
    private Class<? extends CacheStorage> cacheStorageClass;
    private final String localBase;
    private boolean putInCache = false;
    private String proxyHost;
    private int proxyPort = 0;
    private boolean filterJsessionid = true;
    private String authenticationHandler = RemoteUserAuthenticationHandler.class.getName();
    private final Properties properties;
    private boolean preserveHost = false;
    private String cookieStore = SerializableBasicCookieStore.class.getName();
    private String filter = null;
    private final List<String> parsableContentTypes;
    private final Set<String> blackListedHeaders;
    private static final String DEFAULT_PARSABLE_CONTENT_TYPES = "text/html, application/xhtml+xml";
    private static final String DEFAULT_BLACK_LISTED_HEADERS = "Content-Length,Content-Encoding,Transfer-Encoding,Set-Cookie";
    private URL baseURLasURL = null;

    public DriverConfiguration(String instanceName, Properties props) {
        String[] split;
        this.instanceName = instanceName;
        this.baseURL = props.getProperty("remoteUrlBase");
        try {
            if (this.baseURL != null) {
                this.baseURLasURL = new URL(this.baseURL);
            }
        }
        catch (MalformedURLException e1) {
            throw new ConfigurationException(e1);
        }
        if (props.getProperty("uriEncoding") != null) {
            this.uriEncoding = props.getProperty("uriEncoding");
        }
        if (props.getProperty("maxConnectionsPerHost") != null) {
            this.maxConnectionsPerHost = Integer.parseInt(props.getProperty("maxConnectionsPerHost"));
        }
        if (props.getProperty("timeout") != null) {
            this.timeout = Integer.parseInt(props.getProperty("timeout"));
        }
        if (props.getProperty("cacheRefreshDelay") != null) {
            this.cacheRefreshDelay = Integer.parseInt(props.getProperty("cacheRefreshDelay"));
        }
        if (props.getProperty("cacheMaxFileSize") != null) {
            this.cacheMaxFileSize = Integer.parseInt(props.getProperty("cacheMaxFileSize"));
        }
        if (props.getProperty("cacheStorageClassName") != null) {
            String cacheStorageClassName = props.getProperty("cacheStorageClassName");
            try {
                Class<?> cacheStorageClass = this.getClass().getClassLoader().loadClass(cacheStorageClassName);
                if (cacheStorageClass != null) {
                    this.cacheStorageClass = cacheStorageClass;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cashestorage insatnce can not be loaded", e);
            }
        }
        if (null == this.cacheStorageClass) {
            this.cacheStorageClass = DefaultCacheStorage.class;
        }
        this.localBase = props.getProperty("localBase");
        if (props.getProperty("putInCache") != null) {
            this.putInCache = Boolean.parseBoolean(props.getProperty("putInCache"));
        }
        if (props.getProperty("proxyHost") != null && props.getProperty("proxyPort") != null) {
            this.proxyHost = props.getProperty("proxyHost");
            this.proxyPort = Integer.parseInt(props.getProperty("proxyPort"));
        }
        if (props.getProperty("useCache") != null) {
            this.useCache = Boolean.parseBoolean(props.getProperty("useCache"));
        }
        if (props.getProperty("filterJsessionid") != null) {
            this.filterJsessionid = Boolean.parseBoolean(props.getProperty("filterJsessionid"));
        }
        if (props.getProperty("authenticationHandler") != null) {
            this.authenticationHandler = props.getProperty("authenticationHandler");
        }
        if (props.getProperty("cookieStore") != null) {
            this.cookieStore = props.getProperty("cookieStore");
        }
        if (props.getProperty("filter") != null) {
            this.filter = props.getProperty("filter");
        }
        if (props.getProperty("preserveHost") != null) {
            this.preserveHost = Boolean.parseBoolean(props.getProperty("preserveHost"));
        }
        if (props.getProperty("fixResources") != null) {
            this.fixResources = Boolean.parseBoolean(props.getProperty("fixResources"));
            if (props.getProperty("fixMode") != null && "absolute".equalsIgnoreCase(props.getProperty("fixMode"))) {
                this.fixMode = 0;
            }
            this.visibleBaseURL = props.getProperty("visibleUrlBase") != null ? props.getProperty("visibleUrlBase") : this.baseURL;
        }
        String strContentTypes = props.getProperty("parsableContentTypes", DEFAULT_PARSABLE_CONTENT_TYPES);
        StringTokenizer tokenizer = new StringTokenizer(strContentTypes, ",");
        this.parsableContentTypes = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String contentType = tokenizer.nextToken();
            contentType = contentType.trim();
            this.parsableContentTypes.add(contentType);
        }
        this.blackListedHeaders = new HashSet<String>();
        String headers = props.getProperty("blackListedHeaders", DEFAULT_BLACK_LISTED_HEADERS);
        for (String header : split = headers.split(",")) {
            this.blackListedHeaders.add(header.toLowerCase());
        }
        this.properties = props;
    }

    public boolean isBlackListed(String headerName) {
        if (headerName == null || headerName.length() == 0) {
            return true;
        }
        return this.blackListedHeaders.contains(headerName.toLowerCase());
    }

    public String getFilter() {
        return this.filter;
    }

    public int getFixMode() {
        return this.fixMode;
    }

    public boolean isFixResources() {
        return this.fixResources;
    }

    public String getVisibleBaseURL() {
        return this.visibleBaseURL;
    }

    public boolean isPreserveHost() {
        return this.preserveHost;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public int getCacheRefreshDelay() {
        return this.cacheRefreshDelay;
    }

    public int getCacheMaxFileSize() {
        return this.cacheMaxFileSize;
    }

    public String getLocalBase() {
        return this.localBase;
    }

    public boolean isPutInCache() {
        return this.putInCache;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getUriEncoding() {
        return this.uriEncoding;
    }

    public boolean isFilterJsessionid() {
        return this.filterJsessionid;
    }

    public String getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setCookieStore(String cookieStore) {
        this.cookieStore = cookieStore;
    }

    public String getCookieStore() {
        return this.cookieStore;
    }

    public Class<? extends CacheStorage> getCacheStorageClass() {
        return this.cacheStorageClass;
    }

    public List<String> getParsableContentTypes() {
        return this.parsableContentTypes;
    }

    public URL getBaseURLasURL() {
        return this.baseURLasURL;
    }
}

