/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cas;

import java.security.Principal;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.esigate.authentication.GenericAuthentificationHandler;
import org.esigate.http.GenericHttpRequest;
import org.esigate.util.HttpRequestHelper;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasAuthenticationHandler
extends GenericAuthentificationHandler {
    public static final String DEFAULT_LOGIN_URL = "/login";
    private static final Logger LOG = LoggerFactory.getLogger(GenericAuthentificationHandler.class);
    private static final String LOGIN_URL_PROPERTY = "casLoginUrl";
    private static final String SECOND_REQUEST = "SECOND_REQUEST";
    private static final String SPRING_SECURITY_PROPERTY = "isSpringSecurity";
    private static final String SPRING_SECURITY_URL_PATTERN_PROPERTY = "springSecurityUrl";
    private String loginUrl;
    private boolean springSecurity;
    private String springSecurityUrl;

    private String addCasAuthentication(String location, HttpRequest request) {
        String resultLocation = location;
        Principal principal = HttpRequestHelper.getMediator((HttpRequest)request).getUserPrincipal();
        if (principal != null && principal instanceof AttributePrincipal) {
            AttributePrincipal casPrincipal = (AttributePrincipal)principal;
            LOG.debug("User logged in CAS as: " + casPrincipal.getName());
            String springRedirectParam = "";
            if (this.springSecurity) {
                String params = null;
                if (resultLocation.indexOf("?") != -1) {
                    params = resultLocation.substring(resultLocation.indexOf("?"));
                    LOG.debug("params: " + params.substring(1));
                }
                if (this.springSecurityUrl != null && !"".equals(this.springSecurityUrl)) {
                    resultLocation = HttpRequestHelper.getBaseUrl((HttpRequest)request) + this.springSecurityUrl + (params != null ? params : "");
                    springRedirectParam = "&spring-security-redirect=" + location;
                    LOG.debug("getIsSpringSecurity=true => updated location: " + resultLocation);
                }
            }
            String casProxyTicket = casPrincipal.getProxyTicketFor(resultLocation);
            LOG.debug("Proxy ticket retrieved: " + casPrincipal.getName() + " for service: " + location + " : " + casProxyTicket);
            if (casProxyTicket != null) {
                if (resultLocation.indexOf("?") > 0) {
                    return resultLocation + "&ticket=" + casProxyTicket + springRedirectParam;
                }
                return resultLocation + "?ticket=" + casProxyTicket + springRedirectParam;
            }
        }
        return resultLocation;
    }

    public boolean beforeProxy(HttpRequest request) {
        return true;
    }

    public void init(Properties properties) {
        String springSecurityString;
        this.loginUrl = properties.getProperty(LOGIN_URL_PROPERTY);
        if (this.loginUrl == null) {
            this.loginUrl = DEFAULT_LOGIN_URL;
        }
        this.springSecurity = (springSecurityString = properties.getProperty(SPRING_SECURITY_PROPERTY)) != null ? Boolean.parseBoolean(springSecurityString) : false;
        this.springSecurityUrl = properties.getProperty(SPRING_SECURITY_URL_PATTERN_PROPERTY);
    }

    public boolean needsNewRequest(HttpResponse httpResponse, HttpRequest request) {
        if (request.getParams().getBooleanParameter(SECOND_REQUEST, false)) {
            Principal principal;
            Header LocationHeader = httpResponse.getFirstHeader("Location");
            String currentLocation = null;
            if (LocationHeader != null) {
                currentLocation = LocationHeader.getValue();
            }
            if (currentLocation != null && currentLocation.contains(this.loginUrl) && (principal = HttpRequestHelper.getMediator((HttpRequest)request).getUserPrincipal()) != null && principal instanceof AttributePrincipal) {
                return true;
            }
        }
        return false;
    }

    public void preRequest(GenericHttpRequest request, HttpRequest httpRequest) {
        if (httpRequest.getParams().getBooleanParameter(SECOND_REQUEST, false)) {
            request.setUri(this.addCasAuthentication(request.getRequestLine().getUri(), httpRequest));
        }
        httpRequest.getParams().setBooleanParameter(SECOND_REQUEST, true);
    }
}

