/*
 * Decompiled with CFR 0.152.
 */
package org.esigate.cas;

import java.security.Principal;
import java.util.Properties;
import org.esigate.ResourceContext;
import org.esigate.api.HttpRequest;
import org.esigate.authentication.AuthenticationHandler;
import org.esigate.http.HttpClientRequest;
import org.esigate.http.HttpClientResponse;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasAuthenticationHandler
implements AuthenticationHandler {
    public static final String DEFAULT_LOGIN_URL = "/login";
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationHandler.class);
    private static final String LOGIN_URL_PROPERTY = "casLoginUrl";
    private static final String SECOND_REQUEST = "SECOND_REQUEST";
    private static final String SPRING_SECURITY_PROPERTY = "isSpringSecurity";
    private static final String SPRING_SECURITY_URL_PATTERN_PROPERTY = "springSecurityUrl";
    private String loginUrl;
    private boolean springSecurity;
    private String springSecurityUrl;

    private String addCasAuthentication(String location, ResourceContext requestContext) {
        String resultLocation = location;
        Principal principal = requestContext.getOriginalRequest().getUserPrincipal();
        if (principal != null && principal instanceof AttributePrincipal) {
            AttributePrincipal casPrincipal = (AttributePrincipal)principal;
            LOG.debug("User logged in CAS as: " + casPrincipal.getName());
            if (this.springSecurity) {
                String params = null;
                if (resultLocation.indexOf("?") != -1) {
                    params = resultLocation.substring(resultLocation.indexOf("?"));
                    LOG.debug("params: " + params.substring(1));
                }
                if (this.springSecurityUrl != null && !"".equals(this.springSecurityUrl)) {
                    resultLocation = requestContext.getBaseURL() + this.springSecurityUrl + (params != null ? params : "");
                    LOG.debug("getIsSpringSecurity=true => updated location: " + resultLocation);
                }
            }
            String casProxyTicket = casPrincipal.getProxyTicketFor(resultLocation);
            LOG.debug("Proxy ticket retrieved: " + casPrincipal.getName() + " for service: " + location + " : " + casProxyTicket);
            if (casProxyTicket != null) {
                if (resultLocation.indexOf("?") > 0) {
                    return resultLocation + "&ticket=" + casProxyTicket;
                }
                return resultLocation + "?ticket=" + casProxyTicket;
            }
        }
        return resultLocation;
    }

    public boolean beforeProxy(ResourceContext requestContext) {
        return true;
    }

    public void init(Properties properties) {
        String springSecurityString;
        this.loginUrl = properties.getProperty(LOGIN_URL_PROPERTY);
        if (this.loginUrl == null) {
            this.loginUrl = DEFAULT_LOGIN_URL;
        }
        this.springSecurity = (springSecurityString = properties.getProperty(SPRING_SECURITY_PROPERTY)) != null ? Boolean.parseBoolean(springSecurityString) : false;
        this.springSecurityUrl = properties.getProperty(SPRING_SECURITY_URL_PATTERN_PROPERTY);
    }

    public boolean needsNewRequest(HttpClientResponse httpClientResponse, ResourceContext requestContext) {
        Principal principal;
        String currentLocation;
        HttpRequest httpServletRequest = requestContext.getOriginalRequest();
        return httpServletRequest.getAttribute(SECOND_REQUEST) != null && (currentLocation = httpClientResponse.getHeader("Location")) != null && currentLocation.contains(this.loginUrl) && (principal = requestContext.getOriginalRequest().getUserPrincipal()) != null && principal instanceof AttributePrincipal;
    }

    public void preRequest(HttpClientRequest request, ResourceContext requestContext) {
        HttpRequest httpServletRequest = requestContext.getOriginalRequest();
        if (httpServletRequest.getAttribute(SECOND_REQUEST) != null) {
            request.setUri(this.addCasAuthentication(request.getUri(), requestContext));
        }
        httpServletRequest.setAttribute(SECOND_REQUEST, (Object)true);
    }
}

