/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.GenericQueue;
import com.ericsson.otp.erlang.Link;
import com.ericsson.otp.erlang.Links;
import com.ericsson.otp.erlang.OtpCookedConnection;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpNode;

public class OtpMbox {
    OtpNode home;
    OtpErlangPid self;
    GenericQueue queue;
    String name;
    Links links;

    OtpMbox(OtpNode home, OtpErlangPid self, String name) {
        this.self = self;
        this.home = home;
        this.name = name;
        this.queue = new GenericQueue();
        this.links = new Links(10);
    }

    OtpMbox(OtpNode home, OtpErlangPid self) {
        this(home, self, null);
    }

    public OtpErlangPid self() {
        return this.self;
    }

    public synchronized boolean registerName(String name) {
        return this.home.registerName(name, this);
    }

    public String getName() {
        return this.name;
    }

    public OtpErlangObject receive() throws OtpErlangExit, OtpErlangDecodeException {
        try {
            return this.receiveMsg().getMsg();
        }
        catch (OtpErlangExit e) {
            throw e;
        }
        catch (OtpErlangDecodeException f) {
            throw f;
        }
    }

    public OtpErlangObject receive(long timeout) throws OtpErlangExit, OtpErlangDecodeException {
        try {
            OtpMsg m = this.receiveMsg(timeout);
            if (m != null) {
                return m.getMsg();
            }
        }
        catch (OtpErlangExit e) {
            throw e;
        }
        catch (OtpErlangDecodeException f) {
            throw f;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public OtpInputStream receiveBuf() throws OtpErlangExit {
        return this.receiveMsg().getMsgBuf();
    }

    public OtpInputStream receiveBuf(long timeout) throws InterruptedException, OtpErlangExit {
        OtpMsg m = this.receiveMsg(timeout);
        if (m != null) {
            return m.getMsgBuf();
        }
        return null;
    }

    public OtpMsg receiveMsg() throws OtpErlangExit {
        OtpMsg m = (OtpMsg)this.queue.get();
        switch (m.type()) {
            case 3: 
            case 8: {
                try {
                    OtpErlangObject o = m.getMsg();
                    throw new OtpErlangExit(o, m.getSenderPid());
                }
                catch (OtpErlangDecodeException e) {
                    throw new OtpErlangExit("unknown", m.getSenderPid());
                }
            }
        }
        return m;
    }

    public OtpMsg receiveMsg(long timeout) throws InterruptedException, OtpErlangExit {
        OtpMsg m = (OtpMsg)this.queue.get(timeout);
        if (m == null) {
            return null;
        }
        switch (m.type()) {
            case 3: 
            case 8: {
                try {
                    OtpErlangObject o = m.getMsg();
                    throw new OtpErlangExit(o, m.getSenderPid());
                }
                catch (OtpErlangDecodeException e) {
                    throw new OtpErlangExit("unknown", m.getSenderPid());
                }
            }
        }
        return m;
    }

    public void send(OtpErlangPid to, OtpErlangObject msg) {
        try {
            String node = to.node();
            if (node.equals(this.home.node())) {
                this.home.deliver(new OtpMsg(to, (OtpErlangObject)msg.clone()));
            } else {
                OtpCookedConnection conn = this.home.getConnection(node);
                if (conn == null) {
                    return;
                }
                conn.send(this.self, to, msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void send(String name, OtpErlangObject msg) {
        this.home.deliver(new OtpMsg(this.self, name, (OtpErlangObject)msg.clone()));
    }

    public void send(String name, String node, OtpErlangObject msg) {
        try {
            String currentNode = this.home.node();
            if (node.equals(currentNode)) {
                this.send(name, msg);
            } else if (node.indexOf(64, 0) < 0 && node.equals(currentNode.substring(0, currentNode.indexOf(64, 0)))) {
                this.send(name, msg);
            } else {
                OtpCookedConnection conn = this.home.getConnection(node);
                if (conn == null) {
                    return;
                }
                conn.send(this.self, name, msg);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void exit(OtpErlangObject reason) {
        this.home.closeMbox(this, reason);
    }

    public void exit(String reason) {
        this.exit(new OtpErlangAtom(reason));
    }

    public void exit(OtpErlangPid to, OtpErlangObject reason) {
        this.exit(2, to, reason);
    }

    public void exit(OtpErlangPid to, String reason) {
        this.exit(to, new OtpErlangAtom(reason));
    }

    private void exit(int arity, OtpErlangPid to, OtpErlangObject reason) {
        try {
            String node = to.node();
            if (node.equals(this.home.node())) {
                this.home.deliver(new OtpMsg(3, this.self, to, reason));
            } else {
                OtpCookedConnection conn = this.home.getConnection(node);
                if (conn == null) {
                    return;
                }
                switch (arity) {
                    case 1: {
                        conn.exit(this.self, to, reason);
                        break;
                    }
                    case 2: {
                        conn.exit2(this.self, to, reason);
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void link(OtpErlangPid to) throws OtpErlangExit {
        block6: {
            try {
                String node = to.node();
                if (node.equals(this.home.node())) {
                    if (!this.home.deliver(new OtpMsg(1, this.self, to))) {
                        throw new OtpErlangExit("noproc", to);
                    }
                    break block6;
                }
                OtpCookedConnection conn = this.home.getConnection(node);
                if (conn != null) {
                    conn.link(this.self, to);
                    break block6;
                }
                throw new OtpErlangExit("noproc", to);
            }
            catch (OtpErlangExit e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.links.addLink(this.self, to);
    }

    public void unlink(OtpErlangPid to) {
        this.links.removeLink(this.self, to);
        try {
            String node = to.node();
            if (node.equals(this.home.node())) {
                this.home.deliver(new OtpMsg(4, this.self, to));
            } else {
                OtpCookedConnection conn = this.home.getConnection(node);
                if (conn != null) {
                    conn.unlink(this.self, to);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean ping(String node, long timeout) {
        return this.home.ping(node, timeout);
    }

    public String[] getNames() {
        return this.home.getNames();
    }

    public OtpErlangPid whereis(String name) {
        return this.home.whereis(name);
    }

    public void close() {
        this.home.closeMbox(this);
    }

    protected void finalize() {
        this.close();
        this.queue.flush();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OtpMbox)) {
            return false;
        }
        OtpMbox m = (OtpMbox)o;
        return m.self.equals(this.self);
    }

    public int hashCode() {
        return this.self.hashCode();
    }

    void deliver(OtpMsg m) {
        switch (m.type()) {
            case 1: {
                this.links.addLink(this.self, m.getSenderPid());
                break;
            }
            case 4: {
                this.links.removeLink(this.self, m.getSenderPid());
                break;
            }
            case 3: {
                this.links.removeLink(this.self, m.getSenderPid());
                this.queue.put(m);
                break;
            }
            default: {
                this.queue.put(m);
            }
        }
    }

    void breakLinks(OtpErlangObject reason) {
        Link[] l = this.links.clearLinks();
        if (l != null) {
            int len = l.length;
            for (int i = 0; i < len; ++i) {
                this.exit(1, l[i].remote(), reason);
            }
        }
    }
}

