/*
 * Decompiled with CFR 0.152.
 */
package org.equilibriums.aop.utils.interceptor.delegate;

import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;

public class DelegateInterceptor
implements MethodInterceptor {
    private boolean proceed = false;
    private int argumentIndex = 0;
    private String propertyPath = null;
    private Map<Object, Object> delegateMap = null;

    public boolean isProceed() {
        return this.proceed;
    }

    public void setProceed(boolean proceed) {
        this.proceed = proceed;
    }

    public int getArgumentIndex() {
        return this.argumentIndex;
    }

    public void setArgumentIndex(int argumentIndex) {
        this.argumentIndex = argumentIndex;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public void setPropertyPath(String propertyPath) {
        this.propertyPath = propertyPath;
    }

    public Map<Object, Object> getDelegateMap() {
        return this.delegateMap;
    }

    public void setDelegateMap(Map<Object, Object> delegateMap) {
        this.delegateMap = delegateMap;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] arguments = invocation.getArguments();
        if (arguments.length == 0) {
            return null;
        }
        Object key = this.getArgumentPropertyValue(arguments, this.argumentIndex, this.propertyPath);
        Object delegate = this.delegateMap.get(key);
        if (delegate == null) {
            return this.proceed ? invocation.proceed() : null;
        }
        return invocation.getMethod().invoke(delegate, arguments);
    }

    private Object getArgumentPropertyValue(Object[] arguments, Integer argumentIndex, String propertyPath) {
        if (StringUtils.isBlank((String)propertyPath)) {
            return arguments[argumentIndex];
        }
        Object fromPropertyValue = null;
        try {
            fromPropertyValue = PropertyUtils.getProperty((Object)arguments[argumentIndex], (String)propertyPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return fromPropertyValue;
    }
}

