/*
 * Decompiled with CFR 0.152.
 */
package org.equilibriums.aop.utils.interceptor.convert;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.equilibriums.aop.utils.interceptor.convert.Converter;

public class ConvertMethodArgumentInterceptor
implements MethodInterceptor {
    private Converter converter = null;
    private int fromArgumentIndex = 0;
    private String fromPropertyPath = null;
    private int toArgumentIndex = 0;
    private String toPropertyPath = null;

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public int getFromArgumentIndex() {
        return this.fromArgumentIndex;
    }

    public void setFromArgumentIndex(int fromArgumentIndex) {
        this.fromArgumentIndex = fromArgumentIndex;
    }

    public String getFromPropertyPath() {
        return this.fromPropertyPath;
    }

    public void setFromPropertyPath(String fromPropertyPath) {
        this.fromPropertyPath = fromPropertyPath;
    }

    public int getToArgumentIndex() {
        return this.toArgumentIndex;
    }

    public void setToArgumentIndex(int toArgumentIndex) {
        this.toArgumentIndex = toArgumentIndex;
    }

    public String getToPropertyPath() {
        return this.toPropertyPath;
    }

    public void setToPropertyPath(String toPropertyPath) {
        this.toPropertyPath = toPropertyPath;
    }

    public final Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] args = invocation.getArguments();
        if (this.fromArgumentIndex < 0 || this.fromArgumentIndex >= args.length) {
            throw new IllegalArgumentException(String.format("fromArgumentIndex %s is out of bounds with arguments count of %s", this.fromArgumentIndex, args.length));
        }
        if (this.toArgumentIndex < 0 || this.toArgumentIndex >= args.length) {
            throw new IllegalArgumentException(String.format("toArgumentIndex %s is out of bounds with arguments count of %s", this.toArgumentIndex, args.length));
        }
        this.convert(args, this.fromArgumentIndex, this.fromPropertyPath, this.toArgumentIndex, this.toPropertyPath);
        return invocation.proceed();
    }

    private void convert(Object[] args, Integer fromArgumentIndex, String fromPropertyPath, Integer toArgumentIndex, String toPropertyPath) {
        Object convertedValue = this.getConvertedValue(args, fromArgumentIndex, fromPropertyPath);
        if (StringUtils.isBlank((String)toPropertyPath)) {
            args[toArgumentIndex.intValue()] = convertedValue;
        } else {
            try {
                PropertyUtils.setProperty((Object)args[toArgumentIndex], (String)toPropertyPath, (Object)convertedValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Object getConvertedValue(Object[] args, Integer fromArgumentIndex, String fromPropertyPath) {
        if (StringUtils.isBlank((String)fromPropertyPath)) {
            return this.converter.convert(args[fromArgumentIndex]);
        }
        Object fromPropertyValue = null;
        try {
            fromPropertyValue = PropertyUtils.getProperty((Object)args[fromArgumentIndex], (String)fromPropertyPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.converter.convert(fromPropertyValue);
    }
}

