/*
 * Decompiled with CFR 0.152.
 */
package org.equilibriums.aop.utils.interceptor.delegate;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.equilibriums.aop.utils.interceptor.delegate.DelegateReturnValueHandler;

public class DelegateInterceptor
implements MethodInterceptor {
    private List<Object> delegates = null;
    private Map<Object, Method> delegateMethodMap = null;
    private List<DelegateReturnValueHandler> delegateReturnValueHandlers = null;

    public List<Object> getDelegates() {
        return this.delegates;
    }

    public void setDelegates(List<Object> delegates) {
        this.delegates = delegates;
    }

    public Map<Object, Method> getDelegateMethodMap() {
        return this.delegateMethodMap;
    }

    public void setDelegateMethodMap(Map<Object, Method> delegateMethodMap) {
        this.delegateMethodMap = delegateMethodMap;
    }

    public List<DelegateReturnValueHandler> getDelegateReturnValueHandlers() {
        return this.delegateReturnValueHandlers;
    }

    public void setDelegateReturnValueHandlers(List<DelegateReturnValueHandler> delegateReturnValueHandlers) {
        this.delegateReturnValueHandlers = delegateReturnValueHandlers;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.delegates == null || this.delegates.size() == 0) {
            throw new IllegalArgumentException("delegates property needs to specified and cannot be empty");
        }
        Method invocationMethod = invocation.getMethod();
        Object[] invocationMethodArguments = invocation.getArguments();
        ArrayList<Object> returnValues = new ArrayList<Object>();
        for (Object delegate : this.delegates) {
            returnValues.add(this.resolveDelegateMethod(invocationMethod, delegate).invoke(delegate, invocationMethodArguments));
        }
        Class<?> returnType = invocationMethod.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            return null;
        }
        if (this.delegateReturnValueHandlers != null) {
            for (DelegateReturnValueHandler delegateReturnValueHandler : this.delegateReturnValueHandlers) {
                if (!delegateReturnValueHandler.supports(returnType, returnValues)) continue;
                return delegateReturnValueHandler.getReturnValue(returnType, returnValues);
            }
        }
        return null;
    }

    private Method resolveDelegateMethod(Method invocationMethod, Object delegate) {
        if (this.delegateMethodMap == null) {
            return invocationMethod;
        }
        Method delegateMethod = this.delegateMethodMap.get(delegate);
        if (delegateMethod == null) {
            return invocationMethod;
        }
        return delegateMethod;
    }
}

