/*
 * Decompiled with CFR 0.152.
 */
package org.equilibriums.aop.utils.interceptor.convert;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.equilibriums.aop.utils.interceptor.convert.Converter;

public class ConvertMethodReturnValueInterceptor
implements MethodInterceptor {
    private Converter converter = null;
    private String fromPropertyPath = null;
    private String toPropertyPath = null;

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public String getFromPropertyPath() {
        return this.fromPropertyPath;
    }

    public void setFromPropertyPath(String fromPropertyPath) {
        this.fromPropertyPath = fromPropertyPath;
    }

    public String getToPropertyPath() {
        return this.toPropertyPath;
    }

    public void setToPropertyPath(String toPropertyPath) {
        this.toPropertyPath = toPropertyPath;
    }

    public final Object invoke(MethodInvocation invocation) throws Throwable {
        Object returnValue = invocation.proceed();
        returnValue = this.convert(returnValue, this.fromPropertyPath, this.toPropertyPath);
        return returnValue;
    }

    private Object convert(Object returnValue, String fromPropertyPath, String toPropertyPath) {
        Object convertedValue = this.getConvertedValue(returnValue, fromPropertyPath);
        if (StringUtils.isBlank((String)toPropertyPath)) {
            return convertedValue;
        }
        try {
            PropertyUtils.setProperty((Object)returnValue, (String)toPropertyPath, (Object)convertedValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return returnValue;
    }

    private Object getConvertedValue(Object returnValue, String fromPropertyPath) {
        if (StringUtils.isBlank((String)fromPropertyPath)) {
            return this.converter.convert(returnValue);
        }
        Object fromPropertyValue = null;
        try {
            fromPropertyValue = PropertyUtils.getProperty((Object)returnValue, (String)fromPropertyPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.converter.convert(fromPropertyValue);
    }
}

