/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio.channel;

import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.function.Consumer;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.nio.AcceptingSelector;
import org.elasticsearch.transport.nio.SocketSelector;
import org.elasticsearch.transport.nio.channel.ChannelFactory;
import org.elasticsearch.transport.nio.channel.NioServerSocketChannel;
import org.elasticsearch.transport.nio.channel.NioSocketChannel;
import org.elasticsearch.transport.nio.channel.TcpNioServerSocketChannel;
import org.elasticsearch.transport.nio.channel.TcpNioSocketChannel;

public class TcpChannelFactory
extends ChannelFactory<TcpNioServerSocketChannel, TcpNioSocketChannel> {
    private final Consumer<NioSocketChannel> contextSetter;
    private final Consumer<NioServerSocketChannel> serverContextSetter;

    public TcpChannelFactory(TcpTransport.ProfileSettings profileSettings, Consumer<NioSocketChannel> contextSetter, Consumer<NioServerSocketChannel> serverContextSetter) {
        super(new ChannelFactory.RawChannelFactory(profileSettings.tcpNoDelay, profileSettings.tcpKeepAlive, profileSettings.reuseAddress, Math.toIntExact(profileSettings.sendBufferSize.getBytes()), Math.toIntExact(profileSettings.receiveBufferSize.getBytes())));
        this.contextSetter = contextSetter;
        this.serverContextSetter = serverContextSetter;
    }

    @Override
    public TcpNioSocketChannel createChannel(SocketSelector selector, SocketChannel channel) throws IOException {
        TcpNioSocketChannel nioChannel = new TcpNioSocketChannel(channel, selector);
        this.contextSetter.accept(nioChannel);
        return nioChannel;
    }

    @Override
    public TcpNioServerSocketChannel createServerChannel(AcceptingSelector selector, ServerSocketChannel channel) throws IOException {
        TcpNioServerSocketChannel nioServerChannel = new TcpNioServerSocketChannel(channel, this, selector);
        this.serverContextSetter.accept(nioServerChannel);
        return nioServerChannel;
    }
}

