/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.transport.nio.ESSelector;
import org.elasticsearch.transport.nio.SocketEventHandler;
import org.elasticsearch.transport.nio.WriteOperation;
import org.elasticsearch.transport.nio.channel.NioSocketChannel;
import org.elasticsearch.transport.nio.channel.SelectionKeyUtils;
import org.elasticsearch.transport.nio.channel.WriteContext;

public class SocketSelector
extends ESSelector {
    private final ConcurrentLinkedQueue<NioSocketChannel> newChannels = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<WriteOperation> queuedWrites = new ConcurrentLinkedQueue();
    private final SocketEventHandler eventHandler;

    public SocketSelector(SocketEventHandler eventHandler) throws IOException {
        super(eventHandler);
        this.eventHandler = eventHandler;
    }

    public SocketSelector(SocketEventHandler eventHandler, Selector selector) throws IOException {
        super(eventHandler, selector);
        this.eventHandler = eventHandler;
    }

    @Override
    void processKey(SelectionKey selectionKey) {
        NioSocketChannel nioSocketChannel = (NioSocketChannel)selectionKey.attachment();
        int ops = selectionKey.readyOps();
        if ((ops & 8) != 0) {
            this.attemptConnect(nioSocketChannel, true);
        }
        if (nioSocketChannel.isConnectComplete()) {
            if ((ops & 4) != 0) {
                this.handleWrite(nioSocketChannel);
            }
            if ((ops & 1) != 0) {
                this.handleRead(nioSocketChannel);
            }
        }
    }

    @Override
    void preSelect() {
        this.setUpNewChannels();
        this.handleQueuedWrites();
    }

    @Override
    void cleanup() {
        WriteOperation op;
        while ((op = this.queuedWrites.poll()) != null) {
            this.executeFailedListener(op.getListener(), new ClosedSelectorException());
        }
        this.channelsToClose.addAll(this.newChannels);
    }

    public void scheduleForRegistration(NioSocketChannel nioSocketChannel) {
        this.newChannels.offer(nioSocketChannel);
        this.ensureSelectorOpenForEnqueuing(this.newChannels, nioSocketChannel);
        this.wakeup();
    }

    public void queueWrite(WriteOperation writeOperation) {
        this.queuedWrites.offer(writeOperation);
        if (!this.isOpen()) {
            boolean wasRemoved = this.queuedWrites.remove(writeOperation);
            if (wasRemoved) {
                writeOperation.getListener().onFailure((Exception)new ClosedSelectorException());
            }
        } else {
            this.wakeup();
        }
    }

    public void queueWriteInChannelBuffer(WriteOperation writeOperation) {
        assert (this.isOnCurrentThread()) : "Must be on selector thread";
        NioSocketChannel channel = writeOperation.getChannel();
        WriteContext context = channel.getWriteContext();
        try {
            SelectionKeyUtils.setWriteInterested(channel);
            context.queueWriteOperations(writeOperation);
        }
        catch (Exception e) {
            this.executeFailedListener(writeOperation.getListener(), e);
        }
    }

    public <V> void executeListener(ActionListener<V> listener, V value) {
        assert (this.isOnCurrentThread()) : "Must be on selector thread";
        try {
            listener.onResponse(value);
        }
        catch (Exception e) {
            this.eventHandler.listenerException(listener, e);
        }
    }

    public <V> void executeFailedListener(ActionListener<V> listener, Exception exception) {
        assert (this.isOnCurrentThread()) : "Must be on selector thread";
        try {
            listener.onFailure(exception);
        }
        catch (Exception e) {
            this.eventHandler.listenerException(listener, e);
        }
    }

    private void handleWrite(NioSocketChannel nioSocketChannel) {
        try {
            this.eventHandler.handleWrite(nioSocketChannel);
        }
        catch (Exception e) {
            this.eventHandler.writeException(nioSocketChannel, e);
        }
    }

    private void handleRead(NioSocketChannel nioSocketChannel) {
        try {
            this.eventHandler.handleRead(nioSocketChannel);
        }
        catch (Exception e) {
            this.eventHandler.readException(nioSocketChannel, e);
        }
    }

    private void handleQueuedWrites() {
        WriteOperation writeOperation;
        while ((writeOperation = this.queuedWrites.poll()) != null) {
            if (writeOperation.getChannel().isWritable()) {
                this.queueWriteInChannelBuffer(writeOperation);
                continue;
            }
            this.executeFailedListener(writeOperation.getListener(), new ClosedChannelException());
        }
    }

    private void setUpNewChannels() {
        NioSocketChannel newChannel;
        while ((newChannel = this.newChannels.poll()) != null) {
            this.setupChannel(newChannel);
        }
    }

    private void setupChannel(NioSocketChannel newChannel) {
        assert (newChannel.getSelector() == this) : "The channel must be registered with the selector with which it was created";
        try {
            if (newChannel.isOpen()) {
                newChannel.register();
                SelectionKey key = newChannel.getSelectionKey();
                key.attach(newChannel);
                this.eventHandler.handleRegistration(newChannel);
                this.attemptConnect(newChannel, false);
            } else {
                this.eventHandler.registrationException(newChannel, new ClosedChannelException());
            }
        }
        catch (Exception e) {
            this.eventHandler.registrationException(newChannel, e);
        }
    }

    private void attemptConnect(NioSocketChannel newChannel, boolean connectEvent) {
        try {
            if (newChannel.finishConnect()) {
                this.eventHandler.handleConnect(newChannel);
            } else if (connectEvent) {
                this.eventHandler.connectException(newChannel, new IOException("Received OP_CONNECT but connect failed"));
            }
        }
        catch (Exception e) {
            this.eventHandler.connectException(newChannel, e);
        }
    }
}

