/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Random;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class CorruptionUtils {
    private static Logger logger = ESLoggerFactory.getLogger((String)"test");

    private CorruptionUtils() {
    }

    public static void corruptFile(Random random, Path ... files) throws IOException {
        Assert.assertTrue((String)"files must be non-empty", (files.length > 0 ? 1 : 0) != 0);
        Path fileToCorrupt = (Path)RandomPicks.randomFrom((Random)random, (Object[])files);
        Assert.assertTrue((String)(fileToCorrupt + " is not a file"), (boolean)Files.isRegularFile(fileToCorrupt, new LinkOption[0]));
        try (FSDirectory dir = FSDirectory.open((Path)fileToCorrupt.toAbsolutePath().getParent());){
            long actualChecksumAfterCorruption;
            long checksumAfterCorruption;
            long checksumBeforeCorruption;
            try (IndexInput input = dir.openInput(fileToCorrupt.getFileName().toString(), IOContext.DEFAULT);){
                checksumBeforeCorruption = CodecUtil.retrieveChecksum((IndexInput)input);
            }
            var8_7 = null;
            try (FileChannel raf = FileChannel.open(fileToCorrupt, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                raf.position(random.nextInt((int)Math.min(Integer.MAX_VALUE, raf.size())));
                long filePointer = raf.position();
                ByteBuffer bb = ByteBuffer.wrap(new byte[1]);
                raf.read(bb);
                bb.flip();
                byte oldValue = bb.get(0);
                byte newValue = (byte)(oldValue + 1);
                bb.put(0, newValue);
                raf.position(filePointer);
                raf.write(bb);
                logger.info("Corrupting file --  flipping at position {} from {} to {} file: {}", (Object)filePointer, (Object)Integer.toHexString(oldValue), (Object)Integer.toHexString(newValue), (Object)fileToCorrupt.getFileName());
            }
            catch (Throwable filePointer) {
                var8_7 = filePointer;
                throw filePointer;
            }
            try (ChecksumIndexInput input = dir.openChecksumInput(fileToCorrupt.getFileName().toString(), IOContext.DEFAULT);){
                Assert.assertThat((Object)input.getFilePointer(), (Matcher)Matchers.is((Object)0L));
                input.seek(input.length() - 8L);
                checksumAfterCorruption = input.getChecksum();
                actualChecksumAfterCorruption = input.readLong();
            }
            StringBuilder msg = new StringBuilder();
            msg.append("before: [").append(checksumBeforeCorruption).append("] ");
            msg.append("after: [").append(checksumAfterCorruption).append("] ");
            msg.append("checksum value after corruption: ").append(actualChecksumAfterCorruption).append("] ");
            msg.append("file: ").append(fileToCorrupt.getFileName()).append(" length: ").append(dir.fileLength(fileToCorrupt.getFileName().toString()));
            logger.info("Checksum {}", (Object)msg);
            LuceneTestCase.assumeTrue((String)("Checksum collision - " + msg.toString()), (checksumAfterCorruption != checksumBeforeCorruption || actualChecksumAfterCorruption != checksumBeforeCorruption ? 1 : 0) != 0);
            Assert.assertThat((String)"no file corrupted", (Object)fileToCorrupt, (Matcher)Matchers.notNullValue());
        }
    }
}

